/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.VersionSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBaseVersionCommand
extends Command<VersionSpec> {
    private static final Logger logger = LoggerFactory.getLogger(GetBaseVersionCommand.class);
    private final String workingFolder;
    private final String source;
    private final String destination;

    public GetBaseVersionCommand(ServerContext context, String workingFolder, String source, String destination) {
        super("merges", context);
        ArgumentHelper.checkNotEmptyString((String)source, (String)"source");
        ArgumentHelper.checkNotEmptyString((String)destination, (String)"destination");
        this.workingFolder = workingFolder;
        this.source = source;
        this.destination = destination;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder).addSwitch("format", "brief");
        builder.add(this.source);
        builder.add(this.destination);
        return builder;
    }

    @Override
    public VersionSpec parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        int changeset = -1;
        for (String line : this.getLines(stdout)) {
            String changesetText;
            int currentChangeset;
            int changesetEndPos = line.indexOf(" ");
            if (changesetEndPos <= 0 || (currentChangeset = SystemHelper.toInt((String)(changesetText = line.substring(0, changesetEndPos)), (int)-1)) < 0) continue;
            changeset = currentChangeset;
        }
        return changeset >= 0 ? VersionSpec.create(changeset) : null;
    }
}

