/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBranchesCommand
extends Command<List<String>> {
    public static final Logger logger = LoggerFactory.getLogger(GetBranchesCommand.class);
    private static final String CURRENT_PREFIX = ">>";
    private static final String SERVER_PATH_PREFIX = "$";
    private static final String BRANCHED_FROM_PREFIX = "Branched from";
    private final String workingFolder;
    private final String source;

    public GetBranchesCommand(ServerContext context, String workingFolder, String source) {
        super("branches", context);
        ArgumentHelper.checkNotEmptyString((String)workingFolder, (String)"workingFolder");
        ArgumentHelper.checkNotEmptyString((String)source, (String)"source");
        this.workingFolder = workingFolder;
        this.source = source;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder);
        builder.add(this.source);
        return builder;
    }

    @Override
    public List<String> parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        String[] output = this.getLines(stdout);
        ArrayList<String> result = new ArrayList<String>(output.length);
        for (String line : output) {
            if (StringUtils.startsWithIgnoreCase((String)line, (String)CURRENT_PREFIX)) continue;
            int branchedFromIndex = StringUtils.indexOf((String)line, (String)BRANCHED_FROM_PREFIX);
            String serverPath = branchedFromIndex >= 0 ? line.substring(0, branchedFromIndex).trim() : line.trim();
            if (!StringUtils.isNotBlank((String)line)) continue;
            result.add(serverPath);
        }
        return result;
    }
}

