/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.TfvcLabel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetLabelsCommand
extends Command<List<TfvcLabel>> {
    public static final Logger logger = LoggerFactory.getLogger(GetLabelsCommand.class);
    private static final String NO_LABELS = "No labels found.";
    private final String workingFolder;
    private final String labelNameFilter;

    public GetLabelsCommand(ServerContext context, String workingFolder, String labelNameFilter) {
        super("labels", context);
        this.workingFolder = workingFolder;
        this.labelNameFilter = labelNameFilter;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch("format", "xml");
        if (StringUtils.isNotEmpty((String)this.workingFolder)) {
            builder.setWorkingDirectory(this.workingFolder);
        }
        if (StringUtils.isNotEmpty((String)this.labelNameFilter)) {
            builder.add(this.labelNameFilter);
        }
        return builder;
    }

    @Override
    public List<TfvcLabel> parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        ArrayList<TfvcLabel> labels = new ArrayList<TfvcLabel>();
        if (StringUtils.containsIgnoreCase((String)stdout, (String)NO_LABELS)) {
            return labels;
        }
        NodeList nodes = super.evaluateXPath(stdout, "/labels/label");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element label = (Element)nodes.item(i);
                NodeList commentNodes = label.getElementsByTagName("comment");
                String comment = commentNodes.getLength() == 1 ? commentNodes.item(0).getTextContent() : "";
                ArrayList<TfvcLabel.Item> items = new ArrayList<TfvcLabel.Item>(100);
                NodeList childNodes = label.getElementsByTagName("item");
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node child = childNodes.item(j);
                    NamedNodeMap attributes = child.getAttributes();
                    items.add(new TfvcLabel.Item(attributes.getNamedItem("server-item").getNodeValue(), attributes.getNamedItem("changeset").getNodeValue()));
                }
                NamedNodeMap attributes = label.getAttributes();
                labels.add(new TfvcLabel(attributes.getNamedItem("name").getNodeValue(), attributes.getNamedItem("scope").getNodeValue(), attributes.getNamedItem("user").getNodeValue(), attributes.getNamedItem("date").getNodeValue(), comment, items));
            }
        }
        return labels;
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        return super.interpretReturnCode(returnCode == 100 ? 0 : returnCode);
    }
}

