/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import org.apache.commons.lang.StringUtils;

public class GetLocalPathCommand
extends Command<String> {
    private final String serverPath;
    private final String workspace;

    public GetLocalPathCommand(ServerContext context, String serverPath, String workspace) {
        super("resolvePath", context);
        ArgumentHelper.checkNotEmptyString((String)serverPath, (String)"serverPath");
        this.serverPath = serverPath;
        this.workspace = workspace;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().add(this.serverPath);
        if (StringUtils.isNotEmpty((String)this.workspace)) {
            builder.addSwitch("workspace", this.workspace);
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        return stdout.trim();
    }
}

