/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockCommand
extends Command<String> {
    public static final Logger logger = LoggerFactory.getLogger(LockCommand.class);
    private static final String CANNOT_UNLOCK_PREFIX = "TF14090: Cannot unlock";
    private static final String CANNOT_UNLOCK_SUFFIX = "It is not currently locked in your workspace.";
    private final String workingFolder;
    private final LockLevel lockLevel;
    private final boolean recursive;
    private final List<String> itemSpecs;

    public LockCommand(ServerContext context, String workingFolder, LockLevel lockLevel, boolean recursive, List<String> itemSpecs) {
        super("lock", context);
        ArgumentHelper.checkNotEmptyString((String)workingFolder, (String)"workingFolder");
        ArgumentHelper.checkNotNullOrEmpty(itemSpecs, (String)"itemSpecs");
        ArgumentHelper.checkNotNull((Object)((Object)lockLevel), (String)"lockLevel");
        this.workingFolder = workingFolder;
        this.lockLevel = lockLevel;
        this.recursive = recursive;
        this.itemSpecs = itemSpecs;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder).addSwitch("lock", this.lockLevel.toString());
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        for (String item : this.itemSpecs) {
            builder.add(item);
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        if (StringUtils.isEmpty((String)stdout)) {
            this.throwIfError(stderr);
        }
        if (StringUtils.isNotEmpty((String)stderr)) {
            StringBuilder errors = new StringBuilder();
            for (String line : this.getLines(stderr)) {
                if (StringUtils.startsWith((String)line, (String)CANNOT_UNLOCK_PREFIX) && StringUtils.endsWith((String)line, (String)CANNOT_UNLOCK_SUFFIX)) continue;
                errors.append(line);
                errors.append("\n");
            }
            this.throwIfError(errors.toString());
        }
        return "";
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        return super.interpretReturnCode(returnCode == 1 ? 0 : returnCode);
    }

    public static enum LockLevel {
        NONE("none"),
        CHECKIN("checkin"),
        CHECKOUT("checkout");

        private final String value;

        private LockLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static LockLevel fromString(String level) {
            if (StringUtils.equalsIgnoreCase((String)StringUtils.remove((String)level, (String)"-"), (String)CHECKIN.toString())) {
                return CHECKIN;
            }
            if (StringUtils.equalsIgnoreCase((String)StringUtils.remove((String)level, (String)"-"), (String)CHECKOUT.toString())) {
                return CHECKOUT;
            }
            if (StringUtils.isEmpty((String)level) || StringUtils.equalsIgnoreCase((String)level, (String)NONE.toString())) {
                return NONE;
            }
            throw new IllegalArgumentException("level");
        }
    }
}

