/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.MergeMapping;
import com.microsoft.alm.plugin.external.models.MergeResults;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.models.VersionSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCommand
extends Command<MergeResults> {
    private static final Logger logger = LoggerFactory.getLogger(MergeCommand.class);
    private static final String NOTHING_TO_MERGE_MSG = "There are no changes to merge.";
    private static final String WARNING_CHANGES_IGNORED_PREFIX = "TF14121:";
    private static final String CONFLICT_PREFIX = "Conflict (";
    private static final String CHANGES_SEPARATOR = ":";
    private static final String FILE_SEPARATOR = "->";
    private static final String VERSION_SEPARATOR = ";";
    private final String workingFolder;
    private final String source;
    private final String destination;
    private final VersionSpec version;
    private final boolean recursive;

    public MergeCommand(ServerContext context, String workingFolder, String source, String destination, VersionSpec version, boolean recursive) {
        super("merge", context);
        ArgumentHelper.checkNotEmptyString((String)source, (String)"source");
        ArgumentHelper.checkNotEmptyString((String)destination, (String)"destination");
        this.workingFolder = workingFolder;
        this.source = source;
        this.destination = destination;
        this.version = version;
        this.recursive = recursive;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder).addSwitch("format", "detailed");
        if (this.version != null) {
            builder.addSwitch("version", this.version.toString());
        }
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        builder.add(this.source);
        builder.add(this.destination);
        return builder;
    }

    @Override
    public MergeResults parseOutput(String stdout, String stderr) {
        if (StringUtils.contains((String)stdout, (String)NOTHING_TO_MERGE_MSG)) {
            return new MergeResults();
        }
        ArrayList<MergeMapping> mappings = new ArrayList<MergeMapping>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this.getLines(stderr)) {
            if (StringUtils.startsWithIgnoreCase((String)line, (String)CONFLICT_PREFIX)) {
                lines.add(line);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)line, (String)WARNING_CHANGES_IGNORED_PREFIX)) {
                warnings.add(line);
                continue;
            }
            if (!StringUtils.isNotEmpty((String)line)) continue;
            errors.add(line);
        }
        for (String line : this.getLines(stdout)) {
            lines.add(line);
        }
        for (String line : lines) {
            int conflictStartPos = line.indexOf(CONFLICT_PREFIX);
            int changesEndPos = line.indexOf(CHANGES_SEPARATOR);
            int sourceFileEndPos = line.indexOf(FILE_SEPARATOR);
            if (changesEndPos > 0 && sourceFileEndPos > 0) {
                boolean isConflict;
                String changeTypes;
                if (conflictStartPos >= 0) {
                    changeTypes = line.substring(conflictStartPos + CONFLICT_PREFIX.length(), changesEndPos - 1);
                    isConflict = true;
                } else {
                    changeTypes = line.substring(0, changesEndPos);
                    isConflict = false;
                }
                String sourceFile = line.substring(changesEndPos + 1, sourceFileEndPos).trim();
                String targetFile = line.substring(sourceFileEndPos + FILE_SEPARATOR.length() + 1).trim();
                mappings.add(this.createMapping(changeTypes, sourceFile, targetFile, isConflict));
                continue;
            }
            logger.warn("Unknown response from 'tf merge' command: " + line);
        }
        return new MergeResults(mappings, errors, warnings);
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        return returnCode == 1 ? 0 : returnCode;
    }

    private MergeMapping createMapping(String changeTypes, String source, String target, boolean isConflict) {
        List<ServerStatusType> serverStatusTypes = ServerStatusType.getServerStatusTypes(changeTypes);
        String[] parts = StringUtils.split((String)source, (String)VERSION_SEPARATOR);
        String sourceFilename = parts.length > 0 ? parts[0] : "";
        String sourceVersionRange = parts.length > 1 ? parts[1] : "";
        parts = StringUtils.split((String)target, (String)VERSION_SEPARATOR);
        String targetFilename = parts.length > 0 ? parts[0] : "";
        String targetVersion = parts.length > 1 ? parts[1] : "";
        VersionSpec.Range range = VersionSpec.Range.create(sourceVersionRange);
        return new MergeMapping(sourceFilename, targetFilename, range, VersionSpec.create(targetVersion), serverStatusTypes, isConflict);
    }
}

