/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.PendingChange;
import java.util.ArrayList;
import java.util.List;
import jersey.repackaged.com.google.common.collect.ImmutableList;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatusCommand
extends Command<List<PendingChange>> {
    private static final String CANDIDATE_TAG = "candidate-pending-changes";
    private final List<String> localPaths;

    public StatusCommand(ServerContext context, String localPath) {
        this(context, (List<String>)(localPath == null ? null : ImmutableList.of((Object)localPath)));
    }

    public StatusCommand(ServerContext context, List<String> localPaths) {
        super("status", context);
        this.localPaths = localPaths;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch("format", "xml").addSwitch("recursive");
        if (this.localPaths != null) {
            for (String file : this.localPaths) {
                builder.add(file);
            }
        }
        return builder;
    }

    @Override
    public List<PendingChange> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        ArrayList<PendingChange> changes = new ArrayList<PendingChange>(100);
        NodeList nodes = super.evaluateXPath(stdout, "/status/*/pending-change");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attributes = nodes.item(i).getAttributes();
                boolean isCandidate = StringUtils.equalsIgnoreCase((String)nodes.item(i).getParentNode().getNodeName(), (String)CANDIDATE_TAG);
                Node sourceItem = attributes.getNamedItem("source-item");
                changes.add(new PendingChange(attributes.getNamedItem("server-item").getNodeValue(), attributes.getNamedItem("local-item").getNodeValue(), attributes.getNamedItem("version").getNodeValue(), attributes.getNamedItem("owner").getNodeValue(), attributes.getNamedItem("date").getNodeValue(), attributes.getNamedItem("lock").getNodeValue(), attributes.getNamedItem("change-type").getNodeValue(), attributes.getNamedItem("workspace").getNodeValue(), attributes.getNamedItem("computer").getNodeValue(), isCandidate, sourceItem != null ? sourceItem.getNodeValue() : ""));
            }
        }
        return changes;
    }
}

