/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import org.apache.commons.lang.StringUtils;

public class UpdateWorkspaceMappingCommand
extends Command<String> {
    private final Workspace.Mapping mapping;
    private final boolean removeMapping;
    private final String workspaceName;
    private static final String SUB_MAP = "map";
    private static final String SUB_CLOAK = "cloak";
    private static final String SUB_UNMAP = "unmap";
    private static final String SUB_DECLOAK = "decloak";

    public UpdateWorkspaceMappingCommand(ServerContext context, String workspaceName, Workspace.Mapping mapping, boolean removeMapping) {
        super("workfold", context);
        ArgumentHelper.checkNotEmptyString((String)workspaceName, (String)"workspaceName");
        ArgumentHelper.checkNotNull((Object)mapping, (String)"mapping");
        this.workspaceName = workspaceName;
        this.mapping = mapping;
        this.removeMapping = removeMapping;
    }

    private String getSubCommand() {
        if (this.mapping.isCloaked() && this.removeMapping) {
            return SUB_DECLOAK;
        }
        if (!this.mapping.isCloaked() && this.removeMapping) {
            return SUB_UNMAP;
        }
        if (this.mapping.isCloaked() && !this.removeMapping) {
            return SUB_CLOAK;
        }
        return SUB_MAP;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        String subCommand = this.getSubCommand();
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch(subCommand).addSwitch("workspace", this.workspaceName);
        if (this.removeMapping) {
            builder.add(WorkspaceHelper.getNormalizedServerPath(this.mapping.getServerPath()));
        } else {
            builder.add(this.mapping.getServerPath());
        }
        if (StringUtils.equalsIgnoreCase((String)subCommand, (String)SUB_MAP)) {
            builder.add(this.mapping.getLocalPath());
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        return "";
    }
}

