/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.external.models.PendingChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChangeSet {
    private final String id;
    private final String owner;
    private final String committer;
    private final String date;
    private final String comment;
    private final List<PendingChange> changes;

    public ChangeSet(String id, String owner, String committer, String date, String comment, List<PendingChange> changes) {
        this.id = id;
        this.owner = owner;
        this.committer = committer;
        this.date = date;
        this.comment = comment;
        this.changes = new ArrayList<PendingChange>(changes);
    }

    public String getId() {
        return this.id;
    }

    public int getIdAsInt() {
        return SystemHelper.toInt((String)this.id, (int)0);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getCommitter() {
        return this.committer;
    }

    public String getDate() {
        return this.date;
    }

    public String getComment() {
        return this.comment;
    }

    public List<PendingChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }
}

