/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.common.utils.SystemHelper;
import org.apache.commons.lang.StringUtils;

public class ItemInfo {
    private final String serverItem;
    private final String localItem;
    private final String localVersion;
    private final String serverVersion;
    private final String change;
    private final String type;
    private final String lock;
    private final String lockOwner;
    private final String deletionId;
    private final String lastModified;
    private final String fileType;
    private final String fileSize;

    public ItemInfo(String serverItem, String localItem, String serverVersion, String localVersion, String change, String type, String lock, String lockOwner, String deletionId, String lastModified, String fileType, String fileSize) {
        this.serverItem = serverItem;
        this.localItem = localItem;
        this.serverVersion = serverVersion;
        this.localVersion = localVersion;
        this.change = change;
        this.type = type;
        this.lock = lock;
        this.lockOwner = lockOwner;
        this.deletionId = deletionId;
        this.lastModified = lastModified;
        this.fileType = fileType;
        this.fileSize = fileSize;
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public String getLocalItem() {
        return this.localItem;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getServerVersionAsInt() {
        return SystemHelper.toInt((String)this.serverVersion, (int)0);
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    public int getLocalVersionAsInt() {
        return SystemHelper.toInt((String)this.localVersion, (int)0);
    }

    public String getChange() {
        return this.change;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        return this.lock;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getDeletionId() {
        return this.deletionId;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getFileType() {
        return this.fileType;
    }

    public boolean isFolder() {
        return !StringUtils.equalsIgnoreCase((String)this.type, (String)"file");
    }

    public String getFileSize() {
        return this.fileSize;
    }
}

