/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.external.models.MergeMapping;
import java.util.Collections;
import java.util.List;

public class MergeResults {
    private final List<MergeMapping> mappings;
    private final List<String> errors;
    private final List<String> warnings;

    public MergeResults() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public MergeResults(List<MergeMapping> mappings, List<String> errors, List<String> warnings) {
        ArgumentHelper.checkNotNull(mappings, (String)"mappings");
        ArgumentHelper.checkNotNull(mappings, (String)"errors");
        ArgumentHelper.checkNotNull(warnings, (String)"warnings");
        this.mappings = Collections.unmodifiableList(mappings);
        this.errors = errors;
        this.warnings = warnings;
    }

    public List<MergeMapping> getMappings() {
        return this.mappings;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean noChangesToMerge() {
        return this.mappings.size() == 0 && this.errors.size() == 0 && this.warnings.size() == 0;
    }

    public boolean doConflictsExists() {
        for (MergeMapping m : this.mappings) {
            if (!m.isConflict()) continue;
            return true;
        }
        return false;
    }

    public boolean errorsExist() {
        return this.errors.size() > 0;
    }

    public boolean warningsExist() {
        return this.warnings.size() > 0;
    }
}

