/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.plugin.external.models.ServerStatusType;
import java.util.List;

public class PendingChange {
    private final String serverItem;
    private final String localItem;
    private final String version;
    private final String owner;
    private final String date;
    private final String lock;
    private final List<ServerStatusType> changeTypes;
    private final String workspace;
    private final String computer;
    private final boolean isCandidate;
    private final String sourceItem;

    public PendingChange(String serverItem, String changeType) {
        this(serverItem, null, null, null, null, null, changeType, null, null, false, "");
    }

    public PendingChange(String serverItem, String localItem, String version, String owner, String date, String lock, String changeType, String workspace, String computer, boolean isCandidate, String sourceItem) {
        this.serverItem = serverItem;
        this.localItem = localItem;
        this.version = version;
        this.owner = owner;
        this.date = date;
        this.lock = lock;
        this.changeTypes = ServerStatusType.getServerStatusTypes(changeType);
        this.workspace = workspace;
        this.computer = computer;
        this.isCandidate = isCandidate;
        this.sourceItem = sourceItem;
    }

    public String getComputer() {
        return this.computer;
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public String getLocalItem() {
        return this.localItem;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDate() {
        return this.date;
    }

    public String getLock() {
        return this.lock;
    }

    public List<ServerStatusType> getChangeTypes() {
        return this.changeTypes;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public boolean isCandidate() {
        return this.isCandidate;
    }

    public String getSourceItem() {
        return this.sourceItem;
    }
}

