/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerStatusType {
    ADD,
    RENAME,
    EDIT,
    DELETE,
    UNDELETE,
    LOCK,
    BRANCH,
    MERGE,
    UNKNOWN;

    public static final Logger logger;
    public static final String SOURCE_RENAME = "source rename";

    public static List<ServerStatusType> getServerStatusTypes(String statusString) {
        String[] args = StringUtils.split((String)statusString, (String)",");
        ArrayList<ServerStatusType> types = new ArrayList<ServerStatusType>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)ADD.name())) {
                types.add(ADD);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)DELETE.name())) {
                types.add(DELETE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)EDIT.name())) {
                types.add(EDIT);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)RENAME.name()) || StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)SOURCE_RENAME)) {
                types.add(RENAME);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)args[i].trim(), (String)UNDELETE.name())) {
                types.add(UNDELETE);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)args[i].trim(), (String)LOCK.name())) {
                types.add(LOCK);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)args[i].trim(), (String)BRANCH.name())) {
                types.add(BRANCH);
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)args[i].trim(), (String)MERGE.name())) {
                types.add(MERGE);
                continue;
            }
            logger.error("Undocumented status from server: " + args[i]);
            types.add(UNKNOWN);
        }
        return types;
    }

    static {
        logger = LoggerFactory.getLogger(ServerStatusType.class);
    }
}

