/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.plugin.external.exceptions.SyncException;
import java.util.Collections;
import java.util.List;

public class SyncResults {
    private final boolean conflictsExist;
    private final List<String> updatedFiles;
    private final List<String> newFiles;
    private final List<String> deletedFiles;
    private final List<SyncException> exceptions;

    public SyncResults() {
        this(false, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public SyncResults(boolean conflictsExist, List<String> updatedFiles, List<String> newFiles, List<String> deletedFiles, List<SyncException> exceptions) {
        this.conflictsExist = conflictsExist;
        this.updatedFiles = Collections.unmodifiableList(updatedFiles);
        this.newFiles = Collections.unmodifiableList(newFiles);
        this.deletedFiles = Collections.unmodifiableList(deletedFiles);
        this.exceptions = Collections.unmodifiableList(exceptions);
    }

    public boolean doConflictsExists() {
        return this.conflictsExist;
    }

    public List<String> getNewFiles() {
        return this.newFiles;
    }

    public List<String> getUpdatedFiles() {
        return this.updatedFiles;
    }

    public List<String> getDeletedFiles() {
        return this.deletedFiles;
    }

    public List<SyncException> getExceptions() {
        return this.exceptions;
    }
}

