/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import com.microsoft.alm.common.utils.ArgumentHelper;
import org.apache.commons.lang.StringUtils;

public class VersionSpec {
    public static final VersionSpec LATEST = new VersionSpec(Type.Latest, "");
    private final Type type;
    private final String value;

    protected VersionSpec(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public static VersionSpec create(String versionSpecString) {
        if (StringUtils.isEmpty((String)versionSpecString)) {
            return LATEST;
        }
        Type type = Type.fromString(versionSpecString);
        if (type == Type.Latest) {
            return LATEST;
        }
        return new VersionSpec(type, versionSpecString.substring(1));
    }

    public static VersionSpec create(int changeset) {
        if (changeset <= 0) {
            throw new IndexOutOfBoundsException("changeset");
        }
        return new VersionSpec(Type.Changeset, Integer.toString(changeset));
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.type.toString() + this.value;
    }

    public static class Range {
        private static final char RANGE_SEPARATOR = '~';
        private final VersionSpec start;
        private final VersionSpec end;

        public Range(VersionSpec start, VersionSpec end) {
            ArgumentHelper.checkNotNull((Object)start, (String)"start");
            ArgumentHelper.checkNotNull((Object)end, (String)"end");
            this.start = start;
            this.end = end;
        }

        public static Range create(String rangeString) {
            String[] parts = StringUtils.split((String)rangeString, (char)'~');
            if (parts.length == 2) {
                return new Range(VersionSpec.create(parts[0]), VersionSpec.create(parts[1]));
            }
            if (parts.length == 1) {
                return new Range(VersionSpec.create(parts[0]), VersionSpec.create(parts[0]));
            }
            throw new IllegalArgumentException("rangeString");
        }

        public VersionSpec getStart() {
            return this.start;
        }

        public VersionSpec getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start.toString() + '~' + this.end.toString();
        }
    }

    public static enum Type {
        Latest,
        Changeset,
        DateTime,
        Label,
        Workspace;


        public String toString() {
            if (this == Changeset) {
                return "C";
            }
            if (this == DateTime) {
                return "D";
            }
            if (this == Label) {
                return "L";
            }
            if (this == Workspace) {
                return "W";
            }
            return "T";
        }

        public static Type fromString(String typeString) {
            if (StringUtils.isNotEmpty((String)typeString)) {
                switch (typeString.toUpperCase().charAt(0)) {
                    case 'C': {
                        return Changeset;
                    }
                    case 'D': {
                        return DateTime;
                    }
                    case 'L': {
                        return Label;
                    }
                    case 'W': {
                        return Workspace;
                    }
                }
            }
            return Latest;
        }
    }
}

