/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Workspace {
    private final String name;
    private final String computer;
    private final String owner;
    private final String comment;
    private final String server;
    private final List<Mapping> mappings;

    public Workspace(String server, String name, String computer, String owner, String comment, List<Mapping> mappings) {
        this.server = server;
        this.name = name;
        this.computer = computer;
        this.owner = owner;
        this.comment = comment;
        this.mappings = new ArrayList<Mapping>(mappings);
    }

    public String getServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    public String getComputer() {
        return this.computer;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Mapping> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public static class Mapping {
        private final String serverPath;
        private final String localPath;
        private final boolean cloaked;

        public Mapping(String serverPath, String localPath, boolean isCloaked) {
            this.serverPath = serverPath;
            this.localPath = localPath;
            this.cloaked = isCloaked;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public String getServerPath() {
            return this.serverPath;
        }

        public boolean isCloaked() {
            return this.cloaked;
        }
    }

    public static enum Permission {
        PRIVATE,
        PUBLIC_LIMITED,
        PUBLIC;


        public String toString() {
            if (this == PRIVATE) {
                return "Private";
            }
            if (this == PUBLIC) {
                return "Public";
            }
            return "PublicLimited";
        }
    }

    public static enum FileTime {
        CURRENT,
        CHECKIN;


        public String toString() {
            if (this == CHECKIN) {
                return "checkin";
            }
            return "current";
        }
    }
}

