/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.tools;

import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.external.commands.TfVersionCommand;
import com.microsoft.alm.plugin.external.exceptions.ToolBadExitCodeException;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.external.exceptions.ToolVersionException;
import com.microsoft.alm.plugin.external.models.ToolVersion;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.sun.jna.Platform;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfTool {
    private static final Logger logger = LoggerFactory.getLogger(TfTool.class);
    private static final String[] TF_WINDOWS_PROGRAMS = new String[]{"tf.exe", "tf.bat", "tf.cmd"};
    private static final String[] TF_OTHER_PROGRAMS = new String[]{"tf", "tf.sh"};
    private static ToolVersion cachedVersion = null;
    public static final ToolVersion TF_MIN_VERSION = new ToolVersion("14.0.3");
    public static final String TF_DIRECTORY_PREFIX = "TEE-CLC";
    private static final String PATH_ENV = "PATH";
    private static final String TF_HOME_ENV = "TF_HOME";
    private static final String SYSTEM_DRIVE = SystemHelper.getEnvironmentVariable((String)"SystemDrive");
    private static final File[] UNIX_PATHS = new File[]{new File("/opt/local/opt"), new File("/opt"), new File("/sbin"), new File("/usr/share"), new File("/usr/sbin"), new File("/usr/local/opt"), new File("/usr/local/share"), new File("/usr/local")};
    private static File[] PROGRAM_FILE_PATHS = new File[]{new File(SYSTEM_DRIVE, "Program Files"), new File(SYSTEM_DRIVE, "Program Files (x86)"), new File(SYSTEM_DRIVE, "Program Files\\Java")};

    public static String getValidLocation() {
        String[] filenames;
        String location = TfTool.getLocation();
        if (StringUtil.isNullOrEmpty((String)location)) {
            throw new ToolException(ToolException.KEY_TF_HOME_NOT_SET);
        }
        for (String filename : filenames = Platform.isWindows() ? TF_WINDOWS_PROGRAMS : TF_OTHER_PROGRAMS) {
            if (!StringUtils.endsWith((String)location, (String)filename) || !new File(location).exists()) continue;
            return location;
        }
        throw new ToolException(ToolException.KEY_TF_EXE_NOT_FOUND);
    }

    public static String getLocation() {
        return PluginServiceProvider.getInstance().getPropertyService().getProperty("tfHome");
    }

    public static void checkVersion() {
        TfVersionCommand command = new TfVersionCommand();
        cachedVersion = (ToolVersion)command.runSynchronously();
        if (cachedVersion.compare(TF_MIN_VERSION) < 0) {
            throw new ToolVersionException(cachedVersion, TF_MIN_VERSION);
        }
    }

    public static ToolVersion getCachedVersion() {
        return cachedVersion;
    }

    public static void throwBadExitCode(int exitCode) {
        if (exitCode != 0) {
            throw new ToolBadExitCodeException(exitCode);
        }
    }

    public static String tryDetectTf() {
        String[] exeNames = Platform.isWindows() ? TF_WINDOWS_PROGRAMS : TF_OTHER_PROGRAMS;
        File[] filePaths = Platform.isWindows() ? PROGRAM_FILE_PATHS : UNIX_PATHS;
        return TfTool.tryDetectTf(exeNames, filePaths);
    }

    protected static String tryDetectTf(String[] exeNames, File[] filePaths) {
        try {
            String exe = TfTool.checkTfPath(SystemHelper.getEnvironmentVariable((String)TF_HOME_ENV), exeNames);
            if (StringUtils.isNotEmpty((String)exe)) {
                logger.debug("Found exe by TF_HOME: " + exe);
                return exe;
            }
            exe = TfTool.getExeFromPath(exeNames);
            if (StringUtils.isNotEmpty((String)exe)) {
                logger.debug("Found exe by PATH: " + exe);
                return exe;
            }
            exe = TfTool.searchDirectories(filePaths, exeNames);
            if (StringUtils.isNotEmpty((String)exe)) {
                logger.debug("Found exe by Program Files: " + exe);
                return exe;
            }
        }
        catch (Exception e) {
            logger.warn("Error while detecting tf exe", (Throwable)e);
        }
        logger.warn("No tf command was detected");
        return null;
    }

    private static String getExeFromPath(String[] exeNames) {
        String envPath = SystemHelper.getEnvironmentVariable((String)PATH_ENV);
        if (StringUtils.isNotEmpty((String)envPath)) {
            String[] paths;
            for (String path : paths = envPath.split(";")) {
                String verifiedPath;
                File filePath = new File(path);
                if (!StringUtils.startsWith((String)filePath.getName(), (String)TF_DIRECTORY_PREFIX) || !filePath.isDirectory() || (verifiedPath = TfTool.checkTfPath(filePath.getPath(), exeNames)) == null) continue;
                return verifiedPath;
            }
        }
        return null;
    }

    private static String searchDirectories(File[] paths, String[] exeNames) {
        for (File path : paths) {
            if (!path.exists()) continue;
            for (File subDirectory : path.listFiles()) {
                String verifiedPath;
                if (!StringUtils.startsWith((String)subDirectory.getName(), (String)TF_DIRECTORY_PREFIX) || !subDirectory.isDirectory() || (verifiedPath = TfTool.checkTfPath(subDirectory.getPath(), exeNames)) == null) continue;
                return verifiedPath;
            }
        }
        return null;
    }

    private static String checkTfPath(String exePath, String[] exeNames) {
        if (StringUtils.isNotEmpty((String)exePath)) {
            for (String filename : exeNames) {
                File tfFile = new File(exePath, filename);
                if (!tfFile.exists()) continue;
                return tfFile.toString();
            }
        }
        return null;
    }
}

