/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.utils;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WorkspaceHelper {
    public static final String ONE_LEVEL_MAPPING_SUFFIX = "/*";

    public static boolean areMappingsDifferent(Workspace currentWorkspace, Workspace newWorkspace) {
        ArgumentHelper.checkNotNull((Object)currentWorkspace, (String)"currentWorkspace");
        ArgumentHelper.checkNotNull((Object)newWorkspace, (String)"newWorkspace");
        return WorkspaceHelper.areMappingsDifferent(currentWorkspace.getMappings(), newWorkspace.getMappings());
    }

    public static boolean areMappingsDifferent(List<Workspace.Mapping> mappings1, List<Workspace.Mapping> mappings2) {
        if (mappings1 == mappings2) {
            return false;
        }
        if (mappings1 == null || mappings2 == null || mappings1.size() != mappings2.size()) {
            return true;
        }
        Map<String, Workspace.Mapping> map = WorkspaceHelper.getMappingsByServerPath(mappings1);
        for (Workspace.Mapping mapping2 : mappings2) {
            Workspace.Mapping mapping1 = map.get(WorkspaceHelper.getServerPathKey(mapping2.getServerPath()));
            if (mapping1 == null) {
                return true;
            }
            if (mapping1.isCloaked() == mapping2.isCloaked() && StringUtils.equals((String)mapping1.getLocalPath(), (String)mapping2.getLocalPath()) && StringUtils.equals((String)mapping1.getServerPath(), (String)mapping2.getServerPath())) continue;
            return true;
        }
        return false;
    }

    public static List<Workspace.Mapping> getMappingsToRemove(Workspace currentWorkspace, Workspace newWorkspace) {
        ArgumentHelper.checkNotNull((Object)currentWorkspace, (String)"currentWorkspace");
        ArgumentHelper.checkNotNull((Object)newWorkspace, (String)"newWorkspace");
        ArrayList<Workspace.Mapping> mappingsToRemove = new ArrayList<Workspace.Mapping>();
        Map<String, Workspace.Mapping> map = WorkspaceHelper.getMappingsByServerPath(newWorkspace);
        for (Workspace.Mapping mapping : currentWorkspace.getMappings()) {
            if (map.containsKey(WorkspaceHelper.getServerPathKey(mapping.getServerPath()))) continue;
            mappingsToRemove.add(mapping);
        }
        return mappingsToRemove;
    }

    public static List<Workspace.Mapping> getMappingsToChange(Workspace currentWorkspace, Workspace newWorkspace) {
        ArgumentHelper.checkNotNull((Object)currentWorkspace, (String)"currentWorkspace");
        ArgumentHelper.checkNotNull((Object)newWorkspace, (String)"newWorkspace");
        return newWorkspace.getMappings();
    }

    public static Map<String, Workspace.Mapping> getMappingsByServerPath(Workspace workspace) {
        ArgumentHelper.checkNotNull((Object)workspace, (String)"workspace");
        return WorkspaceHelper.getMappingsByServerPath(workspace.getMappings());
    }

    public static Map<String, Workspace.Mapping> getMappingsByServerPath(List<Workspace.Mapping> mappings) {
        ArgumentHelper.checkNotNull(mappings, (String)"mappings");
        HashMap<String, Workspace.Mapping> map = new HashMap<String, Workspace.Mapping>(mappings.size());
        for (Workspace.Mapping mapping : mappings) {
            map.put(WorkspaceHelper.getServerPathKey(mapping.getServerPath()), mapping);
        }
        return map;
    }

    public static String getServerPathKey(String serverPath) {
        ArgumentHelper.checkNotNull((Object)serverPath, (String)"serverPath");
        return serverPath.toLowerCase();
    }

    public static String getNormalizedServerPath(String serverPath) {
        ArgumentHelper.checkNotEmptyString((String)serverPath, (String)"serverPath");
        if (WorkspaceHelper.isOneLevelMapping(serverPath)) {
            return serverPath.substring(0, serverPath.length() - 1).toLowerCase();
        }
        return serverPath.toLowerCase();
    }

    public static String getOneLevelServerPath(String serverPath) {
        if (StringUtils.isEmpty((String)serverPath)) {
            return ONE_LEVEL_MAPPING_SUFFIX;
        }
        if (!WorkspaceHelper.isOneLevelMapping(serverPath)) {
            return StringUtils.stripEnd((String)serverPath, (String)"/") + ONE_LEVEL_MAPPING_SUFFIX;
        }
        return serverPath;
    }

    public static boolean isOneLevelMapping(String serverPath) {
        return StringUtils.endsWith((String)serverPath, (String)ONE_LEVEL_MAPPING_SUFFIX);
    }

    public static String getProxyServer(String serverURI) {
        if (StringUtils.isEmpty((String)serverURI)) {
            return null;
        }
        String propertyName = WorkspaceHelper.getProxyPropertyName(serverURI);
        String currentProxy = PluginServiceProvider.getInstance().getPropertyService().getProperty(propertyName);
        if (StringUtils.isEmpty((String)currentProxy)) {
            return null;
        }
        return currentProxy;
    }

    public static void setProxyServer(String serverURI, String proxyURI) {
        if (StringUtils.isEmpty((String)serverURI)) {
            return;
        }
        String propertyName = WorkspaceHelper.getProxyPropertyName(serverURI);
        if (StringUtils.isEmpty((String)proxyURI)) {
            PluginServiceProvider.getInstance().getPropertyService().removeProperty(propertyName);
        } else {
            PluginServiceProvider.getInstance().getPropertyService().setProperty(propertyName, proxyURI);
        }
    }

    private static String getProxyPropertyName(String serverURI) {
        return "PROXY_" + StringUtils.upperCase((String)StringUtils.stripEnd((String)serverURI, (String)"/"));
    }
}

