/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.visualstudio.services.account.Account;
import com.microsoft.visualstudio.services.account.AccountHttpClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(AccountLookupOperation.class);

    protected AccountLookupOperation() {
    }

    public AccountLookupResults castResults(Operation.Results results) {
        return (AccountLookupResults)results;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        this.onLookupStarted();
        try {
            if (this.isCancelled()) {
                return;
            }
            ServerContext vsoDeploymentContext = ServerContextManager.getInstance().get("https://app.vssps.visualstudio.com");
            if (!VsoAuthenticationProvider.getInstance().isAuthenticated("https://app.vssps.visualstudio.com") || vsoDeploymentContext == null || vsoDeploymentContext.getType() == ServerContext.Type.TFS) {
                logger.warn("doWork unexpected server context, expected type VSO or VSO_DEPLOYMENT. Found: {}", (Object)vsoDeploymentContext);
                throw new TeamServicesException(TeamServicesException.KEY_VSO_AUTH_FAILED);
            }
            AccountHttpClient accountHttpClient = new AccountHttpClient(vsoDeploymentContext.getClient(), UrlHelper.createUri((String)"https://app.vssps.visualstudio.com"));
            List accounts = accountHttpClient.getAccounts(vsoDeploymentContext.getUserId());
            AccountLookupResults results = new AccountLookupResults();
            for (Account a : accounts) {
                ServerContext accountContext = new ServerContextBuilder().type(ServerContext.Type.VSO).accountUri(a).authentication(VsoAuthenticationProvider.getInstance().getAuthenticationInfo("https://app.vssps.visualstudio.com")).userId(vsoDeploymentContext.getUserId()).build();
                results.serverContexts.add(accountContext);
            }
            this.onLookupResults(results);
            this.onLookupCompleted();
        }
        catch (Throwable ex) {
            if (AuthHelper.isNotAuthorizedError(ex)) {
                ServerContext context = ServerContextManager.getInstance().updateAuthenticationInfo("https://app.vssps.visualstudio.com");
                if (context == null) {
                    this.terminate(ex);
                } else {
                    this.doWork(inputs);
                }
            }
            this.terminate(ex);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        AccountLookupResults results = new AccountLookupResults();
        results.isCancelled = true;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    @Override
    protected void terminate(Throwable throwable) {
        super.terminate(throwable);
        AccountLookupResults results = new AccountLookupResults();
        results.error = throwable;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    public static class AccountLookupResults
    extends Operation.ResultsImpl {
        private final List<ServerContext> serverContexts = new ArrayList<ServerContext>();

        public List<ServerContext> getServerContexts() {
            return Collections.unmodifiableList(this.serverContexts);
        }
    }
}

