/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.build.webapi.BuildHttpClient;
import com.microsoft.alm.build.webapi.model.Build;
import com.microsoft.alm.build.webapi.model.BuildQueryOrder;
import com.microsoft.alm.build.webapi.model.BuildRepository;
import com.microsoft.alm.build.webapi.model.BuildResult;
import com.microsoft.alm.build.webapi.model.BuildStatus;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.operations.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildStatusLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(BuildStatusLookupOperation.class);
    public static final String TFVC_REPO_TYPE = "TfsVersionControl";
    private final RepositoryContext repositoryContext;
    private final boolean forcePrompt;

    protected BuildStatusLookupOperation(RepositoryContext repositoryContext, boolean forcePrompt) {
        logger.info("BuildStatusLookupOperation created.");
        ArgumentHelper.checkNotNull((Object)repositoryContext, (String)"repositoryContext");
        this.repositoryContext = repositoryContext;
        this.forcePrompt = forcePrompt;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        try {
            BuildStatusResults results;
            logger.info("BuildStatusLookupOperation.doWork()");
            this.onLookupStarted();
            ServerContext context = Operation.getServerContext(this.repositoryContext, this.forcePrompt, this.forcePrompt, logger);
            if (this.repositoryContext.getType() == RepositoryContext.Type.GIT) {
                logger.info("Getting Git build results.");
                results = this.getGitResults(context);
            } else {
                logger.info("Getting TFVC build results.");
                results = this.getTfvcResults(context);
            }
            logger.info("Returning results.");
            this.onLookupResults(results);
            this.onLookupCompleted();
        }
        catch (Throwable t) {
            logger.warn("doWork: failed with an exception", t);
            this.terminate(t);
        }
    }

    private BuildStatusResults getGitResults(ServerContext context) {
        BuildStatusResults results;
        ArrayList<BuildStatusRecord> buildStatusRecords = new ArrayList<BuildStatusRecord>(2);
        Build latestBuildForRepository = null;
        Build matchingBuild = null;
        if (context.getGitRepository() != null) {
            BuildHttpClient buildClient = context.getBuildHttpClient();
            List builds = buildClient.getBuilds(context.getTeamProjectReference().getId(), null, null, null, null, null, null, null, BuildStatus.COMPLETED, null, null, null, null, Integer.valueOf(100), null, null, null, BuildQueryOrder.FINISH_TIME_DESCENDING);
            if (builds.size() > 0) {
                for (Build b : builds) {
                    BuildRepository repo;
                    if (b.getResult() == BuildResult.CANCELED || (repo = b.getRepository()) == null || !StringUtils.equalsIgnoreCase((String)context.getGitRepository().getId().toString(), (String)repo.getId())) continue;
                    if (StringUtils.equals((String)b.getSourceBranch(), (String)"refs/heads/master")) {
                        if (latestBuildForRepository == null) {
                            logger.info("Latest build found for repo for the master branch.");
                            latestBuildForRepository = b;
                        }
                    } else if (StringUtils.equals((String)b.getSourceBranch(), (String)this.repositoryContext.getBranch()) && matchingBuild == null) {
                        logger.info("Matching build found for repo and branch.");
                        matchingBuild = b;
                    }
                    if (latestBuildForRepository == null || matchingBuild == null) continue;
                    break;
                }
                if (latestBuildForRepository != null) {
                    buildStatusRecords.add(new BuildStatusRecord(latestBuildForRepository));
                }
                if (matchingBuild != null) {
                    buildStatusRecords.add(new BuildStatusRecord(matchingBuild));
                }
                results = new BuildStatusResults(context, buildStatusRecords);
            } else {
                results = new BuildStatusResults(context, null);
            }
        } else {
            results = new BuildStatusResults(null, null);
        }
        return results;
    }

    private BuildStatusResults getTfvcResults(ServerContext context) {
        BuildStatusResults results;
        ArrayList<BuildStatusRecord> buildStatusRecords = new ArrayList<BuildStatusRecord>(2);
        Build matchingBuild = null;
        if (context.getTeamProjectReference() == null || context.getTeamProjectReference().getId() == null) {
            logger.warn("getTfvcResults: The server context object is not correct. So, builds cannot be retrieved.");
            return new BuildStatusResults(context, null);
        }
        BuildHttpClient buildClient = context.getBuildHttpClient();
        List builds = buildClient.getBuilds(context.getTeamProjectReference().getId(), null, null, null, null, null, null, null, BuildStatus.COMPLETED, null, null, null, null, Integer.valueOf(100), null, null, null, BuildQueryOrder.FINISH_TIME_DESCENDING);
        if (builds.size() > 0) {
            for (Build b : builds) {
                BuildRepository repo;
                if (b.getResult() == BuildResult.CANCELED || (repo = b.getRepository()) == null || !StringUtils.equalsIgnoreCase((String)repo.getType(), (String)TFVC_REPO_TYPE)) continue;
                matchingBuild = b;
                break;
            }
            if (matchingBuild != null) {
                buildStatusRecords.add(new BuildStatusRecord(matchingBuild));
            }
            results = new BuildStatusResults(context, buildStatusRecords);
        } else {
            results = new BuildStatusResults(context, null);
        }
        return results;
    }

    @Override
    protected void terminate(Throwable t) {
        super.terminate(t);
        BuildStatusResults results = new BuildStatusResults(null, null);
        results.error = t;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    public static class BuildStatusResults
    extends Operation.ResultsImpl {
        private final ServerContext context;
        private final List<BuildStatusRecord> builds;

        public BuildStatusResults(ServerContext context, List<BuildStatusRecord> builds) {
            logger.info("Creating build status results.");
            logger.info("   builds = " + builds);
            this.context = context;
            this.builds = builds;
        }

        public ServerContext getContext() {
            return this.context;
        }

        public boolean isBuildFound() {
            return this.builds != null && this.builds.size() > 0;
        }

        public List<BuildStatusRecord> getBuilds() {
            if (this.isBuildFound()) {
                return Collections.unmodifiableList(this.builds);
            }
            return Collections.emptyList();
        }

        public BuildStatusRecord getBuildForDisplay() {
            if (this.builds.size() > 0) {
                return this.builds.get(this.builds.size() - 1);
            }
            return null;
        }

        public BuildStatusRecord getRepositoryStatus() {
            if (this.builds.size() > 0) {
                return this.builds.get(0);
            }
            return null;
        }
    }

    public static class BuildStatusRecord {
        private final String repositoryId;
        private final String branch;
        private final boolean successful;
        private final int buildId;
        private final int definitionId;
        private final String buildName;
        private final Date finishTime;

        public BuildStatusRecord(Build build) {
            this.repositoryId = build.getRepository().getId();
            this.branch = build.getSourceBranch();
            this.successful = build.getResult() == BuildResult.SUCCEEDED;
            this.buildId = build.getId();
            this.definitionId = build.getDefinition().getId();
            this.buildName = build.getBuildNumber();
            this.finishTime = build.getFinishTime();
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public String getBranch() {
            return this.branch;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public int getBuildId() {
            return this.buildId;
        }

        public String getBuildName() {
            return this.buildName;
        }

        public int getDefinitionId() {
            return this.definitionId;
        }

        public Date getFinishTime() {
            return this.finishTime;
        }
    }
}

