/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.context.rest.GitHttpClientEx;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.OperationExecutor;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequestSearchCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.PullRequestStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import javax.ws.rs.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(PullRequestLookupOperation.class);
    private final String gitRemoteUrl;
    private final PullRequestLookupResults requestedByMeResults = new PullRequestLookupResults(PullRequestScope.REQUESTED_BY_ME);
    private final PullRequestLookupResults assignedToMeResults = new PullRequestLookupResults(PullRequestScope.ASSIGNED_TO_ME);

    public PullRequestLookupOperation(String gitRemoteUrl) {
        logger.info("PullRequestLookupOperation created.");
        assert (gitRemoteUrl != null);
        this.gitRemoteUrl = gitRemoteUrl;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        ServerContext context;
        logger.info("PullRequestLookupOperation.doWork()");
        this.onLookupStarted();
        if (((Operation.CredInputsImpl)inputs).getPromptForCreds()) {
            final ArrayList authenticatedContexts = new ArrayList();
            ArrayList<Future> authTasks = new ArrayList<Future>();
            try {
                authTasks.add(OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                    @Override
                    public void run() {
                        ServerContext context = ServerContextManager.getInstance().getUpdatedContext(PullRequestLookupOperation.this.gitRemoteUrl, false);
                        if (context != null) {
                            authenticatedContexts.add(context);
                        }
                    }
                }));
                OperationExecutor.getInstance().wait(authTasks);
            }
            catch (Throwable t) {
                logger.warn("doWork: failed to get authenticated server context", t);
                this.terminate((Throwable)new NotAuthorizedException((Object)this.gitRemoteUrl, new Object[0]));
                return;
            }
            if (authenticatedContexts == null || authenticatedContexts.size() != 1) {
                this.terminate((Throwable)new NotAuthorizedException((Object)this.gitRemoteUrl, new Object[0]));
                return;
            }
            context = (ServerContext)authenticatedContexts.get(0);
        } else {
            context = ServerContextManager.getInstance().createContextFromGitRemoteUrl(this.gitRemoteUrl, false);
            if (context == null) {
                this.terminate((Throwable)new NotAuthorizedException((Object)this.gitRemoteUrl, new Object[0]));
                return;
            }
        }
        ArrayList<Future> lookupTasks = new ArrayList<Future>();
        try {
            lookupTasks.add(OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                @Override
                public void run() {
                    PullRequestLookupOperation.this.doLookup(context, PullRequestScope.REQUESTED_BY_ME);
                }
            }));
            lookupTasks.add(OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                @Override
                public void run() {
                    PullRequestLookupOperation.this.doLookup(context, PullRequestScope.ASSIGNED_TO_ME);
                }
            }));
            OperationExecutor.getInstance().wait(lookupTasks);
            this.onLookupCompleted();
        }
        catch (Throwable t) {
            logger.warn("doWork: failed with an exception", t);
            this.terminate(t);
        }
    }

    protected void doLookup(ServerContext context, PullRequestScope scope) {
        try {
            GitHttpClientEx gitHttpClient = context.getGitHttpClient();
            PullRequestLookupResults results = scope == PullRequestScope.REQUESTED_BY_ME ? this.requestedByMeResults : this.assignedToMeResults;
            GitPullRequestSearchCriteria criteria = new GitPullRequestSearchCriteria();
            criteria.setRepositoryId(context.getGitRepository().getId());
            criteria.setStatus(PullRequestStatus.ACTIVE);
            criteria.setIncludeLinks(false);
            if (scope == PullRequestScope.REQUESTED_BY_ME) {
                criteria.setCreatorId(context.getUserId());
            } else {
                criteria.setReviewerId(context.getUserId());
            }
            List pullRequests = gitHttpClient.getPullRequests(context.getGitRepository().getId(), criteria, 256, 0, 101);
            logger.debug("doLookup: Found {} pull requests {} on repo {}", new Object[]{pullRequests.size(), scope.toString(), context.getGitRepository().getRemoteUrl()});
            results.pullRequests.addAll(pullRequests);
            super.onLookupResults(results);
        }
        catch (Throwable t) {
            logger.warn("doLookup: failed with an exception", t);
            this.terminate(t);
        }
    }

    @Override
    protected void terminate(Throwable t) {
        super.terminate(t);
        PullRequestLookupResults results = new PullRequestLookupResults(PullRequestScope.ALL);
        results.error = t;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    public class PullRequestLookupResults
    extends Operation.ResultsImpl {
        private final List<GitPullRequest> pullRequests = new ArrayList<GitPullRequest>();
        private final PullRequestScope scope;

        public PullRequestLookupResults(PullRequestScope scope) {
            this.scope = scope;
        }

        public List<GitPullRequest> getPullRequests() {
            return Collections.unmodifiableList(this.pullRequests);
        }

        public PullRequestScope getScope() {
            return this.scope;
        }
    }

    public static enum PullRequestScope {
        REQUESTED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

    }
}

