/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.client.model.VssResourceNotFoundException;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.CoreHttpClient;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.context.soap.CatalogService;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.OperationExecutor;
import com.microsoft.alm.sourcecontrol.webapi.GitHttpClient;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextLookupOperation
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(ServerContextLookupOperation.class);
    private static final String HTTP_503_EXCEPTION = "HTTP 503 Service Unavailable";
    private final List<ServerContext> contextList;
    private final ContextScope resultScope;

    public ServerContextLookupOperation(List<ServerContext> contextList, ContextScope resultScope) {
        ArgumentHelper.checkNotNullOrEmpty(contextList, (String)"contextList");
        ArgumentHelper.checkNotNull((Object)((Object)resultScope), (String)"resultScope");
        this.contextList = new ArrayList<ServerContext>(contextList.size());
        this.contextList.addAll(contextList);
        this.resultScope = resultScope;
    }

    @Override
    public void doWork(Operation.Inputs inputs) {
        this.onLookupStarted();
        try {
            final boolean throwOnError = this.contextList.size() == 1;
            final CopyOnWriteArrayList operationExceptions = new CopyOnWriteArrayList();
            ArrayList<Future> tasks = new ArrayList<Future>();
            for (final ServerContext context : this.contextList) {
                tasks.add(OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                    @Override
                    public void run() {
                        block11: {
                            if (ServerContextLookupOperation.this.isCancelled()) {
                                return;
                            }
                            try {
                                if (context.getType() == ServerContext.Type.TFS) {
                                    ServerContextLookupOperation.this.doSoapCollectionLookup(context);
                                } else {
                                    ServerContextLookupOperation.this.doRestCollectionLookup(context);
                                }
                            }
                            catch (Throwable t) {
                                boolean shouldReportError = true;
                                logger.warn("doWork: Unable to do lookup on context: " + context.getUri().toString());
                                logger.warn("doWork: Exception", t);
                                if (AuthHelper.isNotAuthorizedError(t)) {
                                    ServerContext newContext = ServerContextManager.getInstance().updateAuthenticationInfo(context.getUri().toString());
                                    try {
                                        if (context.getType() == ServerContext.Type.TFS) {
                                            ServerContextLookupOperation.this.doSoapCollectionLookup(newContext);
                                        } else {
                                            ServerContextLookupOperation.this.doRestCollectionLookup(newContext);
                                        }
                                        shouldReportError = false;
                                    }
                                    catch (Throwable tAgain) {
                                        logger.warn("Failed to lookup repositories even after re-authentication.", tAgain);
                                    }
                                }
                                if (!shouldReportError) break block11;
                                operationExceptions.add(t);
                                if (!throwOnError) break block11;
                                if (t instanceof VssResourceNotFoundException) {
                                    logger.warn(String.format("User authenticated but 404 on server so URI (%s) is malformed", context.getServerUri().toString()));
                                    ServerContextLookupOperation.this.terminate(new TeamServicesException(TeamServicesException.KEY_TFS_MALFORMED_SERVER_URI, t));
                                }
                                ServerContextLookupOperation.this.terminate(t);
                            }
                        }
                    }
                }));
            }
            OperationExecutor.getInstance().wait(tasks);
            if (operationExceptions.size() > 0) {
                this.terminate(new TeamServicesException(TeamServicesException.KEY_OPERATION_ERRORS));
            }
            this.onLookupCompleted();
        }
        catch (Throwable ex) {
            logger.warn("ServerContextLookupOperation failed with an exception", ex);
            this.terminate(ex);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        ServerContextLookupResults results = new ServerContextLookupResults();
        results.isCancelled = true;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    @Override
    protected void terminate(Throwable throwable) {
        super.terminate(throwable);
        ServerContextLookupResults results = new ServerContextLookupResults();
        results.error = throwable;
        this.onLookupResults(results);
        this.onLookupCompleted();
    }

    protected void doRestCollectionLookup(ServerContext context) {
        CoreHttpClient rootClient = new CoreHttpClient(context.getClient(), context.getUri());
        List collections = rootClient.getProjectCollections(null, null);
        logger.debug("doRestCollectionLookup: Found {} collections on account: {}.", (Object)collections.size(), (Object)context.getUri().toString());
        this.doLookup(context, collections);
    }

    protected void doSoapCollectionLookup(ServerContext context) {
        CatalogService catalogService = context.getSoapServices().getCatalogService();
        List<TeamProjectCollectionReference> collections = catalogService.getProjectCollections();
        logger.debug("doSoapCollectionLookup: Found {} collections on server: {}.", (Object)collections.size(), (Object)context.getUri().toString());
        this.doLookup(context, collections);
    }

    protected void doLookup(ServerContext context, List<TeamProjectCollectionReference> collections) {
        for (TeamProjectCollectionReference teamProjectCollectionReference : collections) {
            if (this.isCancelled()) {
                logger.debug("doLookup: Lookup on collection {} on server {} was cancelled.", (Object)teamProjectCollectionReference.getName(), (Object)context.getUri().toString());
                return;
            }
            URI collectionURI = UrlHelper.getCollectionURI((URI)context.getUri(), (String)teamProjectCollectionReference.getName());
            if (this.resultScope == ContextScope.PROJECT) {
                CoreHttpClient client = new CoreHttpClient(context.getClient(), collectionURI);
                List projects = client.getProjects();
                this.addTeamProjectResults(projects, context, teamProjectCollectionReference);
                continue;
            }
            GitHttpClient gitClient = new GitHttpClient(context.getClient(), collectionURI);
            try {
                List gitRepositories = gitClient.getRepositories();
                logger.debug("doLookup: found {} Git repositories in collection: {} on server: {}.", new Object[]{gitRepositories.size(), teamProjectCollectionReference.getName(), context.getUri().toString()});
                this.addRepositoryResults(gitRepositories, context, teamProjectCollectionReference);
            }
            catch (VssResourceNotFoundException e) {
                if (e.getMessage().contains(HTTP_503_EXCEPTION)) {
                    logger.warn("Collection " + teamProjectCollectionReference.getName() + " is unavailable.", (Throwable)e);
                    continue;
                }
                logger.warn("Failure while trying to find collection repos", (Throwable)e);
            }
        }
    }

    protected void addTeamProjectResults(List<TeamProjectReference> projects, ServerContext context, TeamProjectCollectionReference teamProjectCollectionReference) {
        ArrayList<ServerContext> serverContexts = new ArrayList<ServerContext>(projects.size());
        for (TeamProjectReference project : projects) {
            ServerContext projectServerContext = new ServerContextBuilder(context).teamProject(project).collection(teamProjectCollectionReference).build();
            serverContexts.add(projectServerContext);
        }
        ServerContextLookupResults results = new ServerContextLookupResults();
        results.serverContexts.addAll(serverContexts);
        super.onLookupResults(results);
    }

    protected void addRepositoryResults(List<GitRepository> gitRepositories, ServerContext context, TeamProjectCollectionReference teamProjectCollectionReference) {
        ArrayList<ServerContext> serverContexts = new ArrayList<ServerContext>(gitRepositories.size());
        for (GitRepository gitRepository : gitRepositories) {
            ServerContext gitServerContext = new ServerContextBuilder(context).uri(gitRepository.getRemoteUrl()).repository(gitRepository).teamProject(gitRepository.getProjectReference()).collection(teamProjectCollectionReference).build();
            serverContexts.add(gitServerContext);
        }
        ServerContextLookupResults results = new ServerContextLookupResults();
        results.serverContexts.addAll(serverContexts);
        logger.debug("addRepositoryResults: {} contexts were added to lookup results for {} Git repositories found on the server: {} with resultScope = {}.", new Object[]{serverContexts.size(), gitRepositories.size(), context.getUri().toString(), this.resultScope.toString()});
        super.onLookupResults(results);
    }

    public class ServerContextLookupResults
    extends Operation.ResultsImpl {
        private final List<ServerContext> serverContexts = new ArrayList<ServerContext>();

        public List<ServerContext> getServerContexts() {
            return Collections.unmodifiableList(this.serverContexts);
        }
    }

    public static enum ContextScope {
        REPOSITORY,
        PROJECT;

    }
}

