/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.services;

import com.microsoft.alm.plugin.services.AsyncService;
import com.microsoft.alm.plugin.services.CredentialsPrompt;
import com.microsoft.alm.plugin.services.DeviceFlowResponsePrompt;
import com.microsoft.alm.plugin.services.HttpProxyService;
import com.microsoft.alm.plugin.services.LocalizationService;
import com.microsoft.alm.plugin.services.PluginContextInitializer;
import com.microsoft.alm.plugin.services.PropertyService;
import com.microsoft.alm.plugin.services.ServerContextStore;

public class PluginServiceProvider {
    private boolean initialized = false;
    private boolean insideIDE = false;
    private ServerContextStore contextStore;
    private CredentialsPrompt credentialsPrompt;
    private DeviceFlowResponsePrompt deviceFlowResponsePrompt;
    private PluginContextInitializer telemetryContextInitializer;
    private PropertyService propertyService;
    private LocalizationService localizationSerivce;
    private HttpProxyService httpProxyService;
    private AsyncService asyncService;

    public static PluginServiceProvider getInstance() {
        return ProviderHolder.INSTANCE;
    }

    public void initialize(ServerContextStore contextStore, CredentialsPrompt credentialsPrompt, DeviceFlowResponsePrompt deviceFlowResponsePrompt, PluginContextInitializer telemetryContextInitializer, PropertyService propertyService, LocalizationService localizationService, HttpProxyService httpProxyService, AsyncService asyncService, boolean insideIDE) {
        if (!this.initialized) {
            this.contextStore = contextStore;
            this.credentialsPrompt = credentialsPrompt;
            this.deviceFlowResponsePrompt = deviceFlowResponsePrompt;
            this.telemetryContextInitializer = telemetryContextInitializer;
            this.propertyService = propertyService;
            this.localizationSerivce = localizationService;
            this.httpProxyService = httpProxyService;
            this.asyncService = asyncService;
            this.insideIDE = insideIDE;
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isInsideIDE() {
        return this.insideIDE;
    }

    public ServerContextStore getServerContextStore() {
        assert (this.initialized);
        assert (this.contextStore != null);
        return this.contextStore;
    }

    public CredentialsPrompt getCredentialsPrompt() {
        assert (this.initialized);
        assert (this.credentialsPrompt != null);
        return this.credentialsPrompt;
    }

    public PluginContextInitializer getTelemetryContextInitializer() {
        assert (this.initialized);
        assert (this.telemetryContextInitializer != null);
        return this.telemetryContextInitializer;
    }

    public PropertyService getPropertyService() {
        assert (this.initialized);
        assert (this.propertyService != null);
        return this.propertyService;
    }

    public LocalizationService getLocalizationService() {
        assert (this.initialized);
        assert (this.localizationSerivce != null);
        return this.localizationSerivce;
    }

    public HttpProxyService getHttpProxyService() {
        assert (this.initialized);
        assert (this.httpProxyService != null);
        return this.httpProxyService;
    }

    public DeviceFlowResponsePrompt getDeviceFlowResponsePrompt() {
        assert (this.initialized);
        assert (this.deviceFlowResponsePrompt != null);
        return this.deviceFlowResponsePrompt;
    }

    public AsyncService getAsyncService() {
        assert (this.initialized);
        assert (this.asyncService != null);
        return this.asyncService;
    }

    private static class ProviderHolder {
        private static PluginServiceProvider INSTANCE = new PluginServiceProvider();

        private ProviderHolder() {
        }
    }
}

