/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.telemetry;

import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.services.PluginContextInitializer;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryInstrumentationInfo;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.SessionState;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsTelemetryHelper {
    private static final Logger logger = LoggerFactory.getLogger(TfsTelemetryHelper.class);
    public static final String UNIQUE_PREFIX = "ai-log";
    public static final String BASE_FOLDER = "AppInsights";
    public static final String UNKNOWN = "unknown";
    private TelemetryClient telemetryClient;

    private static TfsTelemetryHelper getInstance() {
        return TfsTelemetryHelperHolder.INSTANCE;
    }

    private TfsTelemetryHelper() {
        String skip = System.getProperties().getProperty("com.microsoft.alm.plugin.telemetry.skipClientInitialization");
        if (StringUtils.isNotEmpty((String)skip) && StringUtils.equalsIgnoreCase((String)skip, (String)"true")) {
            return;
        }
        HashMap<String, String> loggerData = new HashMap<String, String>();
        loggerData.put("Level", InternalLogger.LoggingLevel.ERROR.toString());
        loggerData.put("UniquePrefix", UNIQUE_PREFIX);
        loggerData.put("BaseFolder", BASE_FOLDER);
        InternalLogger.INSTANCE.initialize(InternalLogger.LoggerOutputType.FILE.toString(), loggerData);
        PluginContextInitializer initializer = PluginServiceProvider.getInstance().getTelemetryContextInitializer();
        TelemetryConfiguration.getActive().getContextInitializers().add(initializer);
        TelemetryChannel channel = TelemetryConfiguration.getActive().getChannel();
        if (channel == null) {
            logger.error("Failed to load telemetry channel");
            return;
        }
        channel.setDeveloperMode(TfsTelemetryInstrumentationInfo.getInstance().isDeveloperMode());
        logger.debug("AppInsights telemetry initialized");
        logger.debug(MessageFormat.format("    Developer Mode: {0}", TfsTelemetryInstrumentationInfo.getInstance().isDeveloperMode()));
        logger.debug(MessageFormat.format("    Production Environment: {0}", !TfsTelemetryInstrumentationInfo.getInstance().isTestKey()));
        this.telemetryClient = new TelemetryClient();
    }

    public void sendMetric(String name, double value) {
        logger.debug(String.format("sendMetric(%s, %f)", name, value));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackMetric(name, value);
        }
    }

    public void sendDialogOpened(String name, Map<String, String> properties) {
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        String pageName = String.format("VSO/Plugin/Dialog/%s", name);
        logger.debug(String.format("sendDialogOpened(%s, %s)", pageName, builder.toString()));
        if (this.telemetryClient != null) {
            PageViewTelemetry telemetry = new PageViewTelemetry(pageName);
            telemetry.getProperties().putAll(builder.build());
            this.telemetryClient.trackPageView(telemetry);
        }
    }

    public void sendEvent(String name, Map<String, String> properties) {
        String eventName = String.format("VSO/Plugin/Action/%s", name);
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        logger.debug(String.format("sendEvent(%s, %s)", name, builder.toString()));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackEvent(eventName, builder.build(), null);
        }
    }

    public void sendException(Exception exception, Map<String, String> properties) {
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        logger.debug(String.format("sendException(%s, %s)", exception.getMessage(), builder.toString()));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackException(exception, builder.build(), null);
        }
    }

    private void sendSessionState(SessionState state) {
        logger.debug(String.format("sendSessionState(%s)", state.toString()));
        if (this.telemetryClient != null) {
            this.telemetryClient.trackSessionState(state);
        }
    }

    public static void sendEventAsync(final String name, final Map<String, String> properties) {
        try {
            PluginServiceProvider.getInstance().getAsyncService().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    TfsTelemetryHelper.getInstance().sendEvent(name, properties);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error sending event telemetry", (Throwable)e);
        }
    }

    public static void sendDialogOpenedAsync(final String name, final Map<String, String> properties) {
        try {
            PluginServiceProvider.getInstance().getAsyncService().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    TfsTelemetryHelper.getInstance().sendDialogOpened(name, properties);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error sending dialog telemetry", (Throwable)e);
        }
    }

    public static void sendMetricAsync(final String name, final double value) {
        try {
            PluginServiceProvider.getInstance().getAsyncService().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    TfsTelemetryHelper.getInstance().sendMetric(name, value);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error sending metric telemetry", (Throwable)e);
        }
    }

    public static void sendExceptionAsync(final Exception exception, final Map<String, String> properties) {
        try {
            PluginServiceProvider.getInstance().getAsyncService().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    TfsTelemetryHelper.getInstance().sendException(exception, properties);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error sending exception telemetry", (Throwable)e);
        }
    }

    public static class PropertyMapBuilder {
        public static final Map<String, String> EMPTY = new PropertyMapBuilder().build();
        private Map<String, String> properties = new HashMap<String, String>();

        public PropertyMapBuilder() {
            this(null);
        }

        public PropertyMapBuilder(Map<String, String> properties) {
            this.properties = properties != null ? new HashMap<String, String>(properties) : new HashMap<String, String>();
        }

        public Map<String, String> build() {
            return new HashMap<String, String>(this.properties);
        }

        public PropertyMapBuilder serverContext(ServerContext context) {
            if (context != null) {
                boolean isHosted = context.getType() == ServerContext.Type.VSO || context.getType() == ServerContext.Type.VSO_DEPLOYMENT;
                this.add("VSO.TeamFoundationServer.IsHostedServer", Boolean.toString(isHosted));
                this.add("VSO.TeamFoundationServer.ServerId", this.getServerId(context));
                this.add("VSO.TeamFoundationServer.CollectionId", this.getCollectionId(context));
            }
            return this;
        }

        public PropertyMapBuilder activeServerContext() {
            if (ServerContextManager.getInstance().getLastUsedContext() != null) {
                return this.serverContext(ServerContextManager.getInstance().getLastUsedContext());
            }
            return this;
        }

        public PropertyMapBuilder currentOrActiveContext(ServerContext context) {
            if (context != null) {
                return this.serverContext(context);
            }
            return this.activeServerContext();
        }

        public PropertyMapBuilder actionName(String actionName) {
            if (!StringUtils.isEmpty((String)actionName)) {
                this.add("VSO.Plugin.Property.Name", actionName);
            }
            return this;
        }

        public PropertyMapBuilder success(Boolean success) {
            if (success != null) {
                this.add("VSO.Plugin.Property.Success", success.toString());
            }
            return this;
        }

        public PropertyMapBuilder message(String message) {
            if (!StringUtils.isEmpty((String)message)) {
                this.add("VSO.Plugin.Property.Message", message);
            }
            return this;
        }

        public PropertyMapBuilder pair(String key, String value) {
            if (!StringUtils.isEmpty((String)key) && !StringUtils.isEmpty((String)value)) {
                this.add(key, value);
            }
            return this;
        }

        private String getServerId(ServerContext context) {
            if (context != null && context.getUri() != null) {
                return context.getUri().getHost();
            }
            return TfsTelemetryHelper.UNKNOWN;
        }

        private String getCollectionId(ServerContext context) {
            if (context != null && context.getTeamProjectCollectionReference() != null && context.getTeamProjectCollectionReference().getId() != null) {
                return context.getTeamProjectCollectionReference().getId().toString();
            }
            return TfsTelemetryHelper.UNKNOWN;
        }

        private void add(String key, String value) {
            if (value != null) {
                this.properties.put(key, value.replace("\r", "").replace("\n", " "));
            } else {
                this.properties.put(key, "");
            }
        }

        public String toString() {
            return this.properties.toString();
        }
    }

    private static class TfsTelemetryHelperHolder {
        private static final TfsTelemetryHelper INSTANCE = new TfsTelemetryHelper();

        private TfsTelemetryHelperHolder() {
        }
    }
}

