/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.telemetry;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsTelemetryInstrumentationInfo {
    private static final Logger logger = LoggerFactory.getLogger(TfsTelemetryInstrumentationInfo.class);
    private static final String TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE = "/telemetry/com.microsoft.alm.plugin-telemetry.properties";
    private static final String VSO_INTELLIJ_PROD_KEY = "132bb2e2-06d4-4908-a34b-87be041cc31c";
    private static final String VSO_INTELLIJ_TEST_KEY = "07da2cb6-eed8-4361-b364-ecf1a1559ae7";
    private static boolean isTestEnv;
    private static boolean isDeveloperMode;

    protected TfsTelemetryInstrumentationInfo() {
        InputStream in = TfsTelemetryInstrumentationInfo.class.getResourceAsStream(TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE);
        this.initialize(in);
    }

    public static TfsTelemetryInstrumentationInfo getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void initialize(InputStream in) {
        block11: {
            block12: {
                block10: {
                    isTestEnv = false;
                    isDeveloperMode = false;
                    if (in == null) break block12;
                    Properties props = new Properties();
                    props.load(in);
                    String isTestEnvProperty = props.getProperty("telemetry.instrumentation.is_test_environment");
                    String isDeveloperModeProperty = props.getProperty("telemetry.instrumentation.is_developer_mode");
                    if (!StringUtils.isNotEmpty((String)isTestEnvProperty) || !Boolean.parseBoolean(isTestEnvProperty)) break block10;
                    isTestEnv = true;
                    if (!StringUtils.isNotEmpty((String)isDeveloperModeProperty) || !Boolean.parseBoolean(isDeveloperModeProperty)) break block10;
                    isDeveloperMode = true;
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn(MessageFormat.format("Unable to dispose property resource {0} with exception {1}", TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE, e));
                }
                break block11;
                catch (IOException e) {
                    try {
                        logger.warn(MessageFormat.format("Unable to load property resource {0} with exception {1}", TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE, e));
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            logger.warn(MessageFormat.format("Unable to dispose property resource {0} with exception {1}", TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE, e2));
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        logger.warn(MessageFormat.format("Unable to dispose property resource {0} with exception {1}", TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE, e3));
                    }
                    break block11;
                }
            }
            logger.warn(MessageFormat.format("Unable to locate property resource {0}", TELEMETRY_INSTRUMENTATION_PROPERTIES_RESOURCE));
        }
    }

    public boolean isDeveloperMode() {
        return isDeveloperMode;
    }

    public boolean isTestKey() {
        return isTestEnv;
    }

    public String getInstrumentationKey() {
        return this.isTestKey() ? VSO_INTELLIJ_TEST_KEY : VSO_INTELLIJ_PROD_KEY;
    }

    private static class Holder {
        private static final TfsTelemetryInstrumentationInfo INSTANCE = new TfsTelemetryInstrumentationInfo();

        private Holder() {
        }
    }
}

