/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.extensibility.modules.WebTelemetryModule;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class WebModulesContainer {
    private List<WebTelemetryModule> modules = new ArrayList<WebTelemetryModule>();
    private int modulesCount = 0;

    public WebModulesContainer(TelemetryConfiguration configuration) {
        this.buildWebModules(configuration);
        this.modulesCount = this.modules.size();
    }

    public void invokeOnBeginRequest(ServletRequest req, ServletResponse res) {
        for (WebTelemetryModule module : this.modules) {
            try {
                module.onBeginRequest(req, res);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Web module " + module.getClass().getSimpleName() + " failed on BeginRequest with exception: %s", new Object[]{e.getMessage()});
            }
        }
    }

    public void invokeOnEndRequest(ServletRequest req, ServletResponse res) {
        for (WebTelemetryModule module : this.modules) {
            try {
                module.onEndRequest(req, res);
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Web module " + module.getClass().getSimpleName() + " failed on EndRequest with exception: %s", new Object[]{e.getMessage()});
            }
        }
    }

    public int getModulesCount() {
        return this.modulesCount;
    }

    private void buildWebModules(TelemetryConfiguration configuration) {
        for (TelemetryModule module : configuration.getTelemetryModules()) {
            if (!(module instanceof WebTelemetryModule)) continue;
            this.modules.add((WebTelemetryModule)module);
        }
    }
}

