/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseDialect {
    @NotNull
    public DatabaseFamilyId getFamilyId();

    @NotNull
    public Icon getIcon();

    @NotNull
    public String getDisplayName();

    public char closeQuote();

    public char openQuote();

    @Nullable
    public String getNameForKind(@NotNull ObjectKind var1);

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public String quoteIdentifier(String var1, boolean var2, boolean var3);

    @Contract(value="null->null;!null->!null")
    public String unquoteIdentifier(String var1);

    @Contract(value="null->false")
    public boolean isQuotedIdentifier(@Nullable String var1);

    public boolean supportsCorrelatedSubQuery();

    public boolean supportsSubSecondTimestamps();

    @NotNull
    public String getTypeName(DataType var1);

    public int getJavaTypeForNativeType(@NotNull String var1);

    public String getBinaryLiteralString(byte[] var1);

    public boolean supportsSequence();

    public boolean supportsTablespace();

    public boolean supportsIndexes();

    public boolean supportsAccessMethods();

    public boolean supportsAutoIncrement();

    public boolean supportsCheckOptionsForViews();

    public boolean supportsEmptyTables();

    public boolean supportsMultipleRowInserts();

    public boolean supportsInsertInto();

    public boolean supportsSequenceInformation();

    public boolean supportsSchemasInTableDefinition();

    @NotNull
    public String getNullColumnString();

    @NotNull
    public String getMaxFunction();

    @NotNull
    public String getLengthFunction();

    public boolean supportsProduct(@Nullable String var1, @NotNull String var2);

    public boolean supportsCreateDatabase();

    public boolean supportsRenameDatabase();

    public boolean supportsCreateSchema();

    public boolean supportsRenameSchema();

    public boolean supportsColumnComment();

    public boolean supportsColumnCommentsInTableDefinition();

    public boolean supportsDropColumn();

    public boolean supportsAlterColumnNull();

    public boolean supportsAddPrimaryKey();

    public boolean supportsRenameRoutine();

    public boolean supportsRenameColumn();

    public boolean supportsModifyColumn();

    public boolean supportsAlterColumnType();

    public boolean supportsAlterColumnDefault();

    public boolean supportsDropPrimaryKey();

    public boolean supportsDropForeignKey();

    public boolean supportsCreateTable();

    @Nullable
    public String[] getIndexAccessMethodsTypes();

    @Nullable
    public String[] getIndexStorageOptions();

    public boolean supportsRenameTable();

    public boolean supportsCreateView();

    public boolean supportsRenameView();

    public boolean supportsDropView();

    public boolean supportsDropMaterializedView();

    public boolean supportsDropOperator();

    public boolean supportsDropType();

    public boolean supportsDropSchema();

    public boolean supportsDropDatabase();

    public boolean supportsDropProcedure();

    public boolean supportsCreateIndex();

    public boolean supportsDropIndex();

    public boolean supportsCreateSequence();

    public boolean supportsAlterSequence();

    public boolean supportsDropSequence();

    public boolean supportsAddForeignKey();

    public boolean supportsAddUniqueConstraint();

    public boolean supportsDropConstraint();

    public boolean supportsDropTrigger();

    public boolean supportsDropRule();

    public boolean supportsDropPackage();

    public boolean supportsDropCluster();

    public boolean supportsDropSynonym();

    public boolean supportsAddColumn();

    public boolean supportsViewDefinition();

    public boolean supportsSystemViewDefinition();

    public boolean supportsTableDefinition();

    public boolean supportsTableInfo();

    public boolean supportsProcedureDefinition();

    public boolean supportsPackageDefinition();

    public boolean supportsSequenceDefinition();

    public boolean supportsSynonymDefinition();

    public boolean supportsQualifiedAsteriskInCalls();

    public boolean supportsCommonTableExpression();
}

