/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.IOHelper;
import com.microsoft.alm.helpers.QueryString;
import com.microsoft.alm.helpers.StringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringContent {
    private static final String UTF8 = Charset.forName("UTF-8").name();
    private static final String CONTENT_TYPE_TEMPLATE = "%1$s; charset=%2$s";
    public final Map<String, String> Headers = new LinkedHashMap<String, String>();
    private final String content;
    private final byte[] bytes;

    private StringContent(String content, String mediaType) {
        this.content = content;
        this.bytes = StringHelper.UTF8GetBytes(content);
        String contentType = String.format(CONTENT_TYPE_TEMPLATE, mediaType, UTF8);
        this.Headers.put("Content-Type", contentType);
        String contentLength = Integer.toString(this.bytes.length, 10);
        this.Headers.put("Content-Length", contentLength);
    }

    public String getContent() {
        return this.content;
    }

    public static StringContent createUrlEncoded(QueryString parameters) {
        return new StringContent(parameters.toString(), "application/x-www-form-urlencoded");
    }

    public static StringContent createJson(String json) {
        return new StringContent(json, "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HttpURLConnection connection) throws IOException {
        for (Map.Entry<String, String> entry : this.Headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            connection.setRequestProperty(key, value);
        }
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            outputStream.write(this.bytes);
        }
        finally {
            IOHelper.closeQuietly(outputStream);
        }
    }
}

