/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.StringHelper;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Secret {
    private static final Logger logger = LoggerFactory.getLogger(Secret.class);
    public static IUriNameConversion DefaultUriNameConversion = new IUriNameConversion(){

        @Override
        public String convert(URI targetUri, String namespace) {
            return Secret.uriToName(targetUri, namespace);
        }
    };

    public static String uriToName(URI targetUri, String namespace) {
        String TokenNameBaseFormat = "%1$s:%2$s://%3$s";
        String TokenNamePortFormat = "%1$s:%2$s://%3$s:%4$s";
        Debug.Assert(targetUri != null, "The targetUri parameter is null");
        logger.debug("Secret::uriToName");
        String targetName = null;
        String trimmedHostUrl = StringHelper.trimEnd(StringHelper.trimEnd(targetUri.getHost(), '/', '\\'));
        targetName = targetUri.getPort() == -1 ? String.format("%1$s:%2$s://%3$s", namespace, targetUri.getScheme(), trimmedHostUrl) : String.format("%1$s:%2$s://%3$s:%4$s", namespace, targetUri.getScheme(), trimmedHostUrl, targetUri.getPort());
        logger.debug("   target name = {}", (Object)targetName);
        return targetName;
    }

    public static class PrefixedUriNameConversion
    implements IUriNameConversion {
        private final String prefix;

        public PrefixedUriNameConversion(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String convert(URI targetUri, String namespace) {
            return Secret.uriToName(targetUri, this.prefix + namespace);
        }
    }

    public static interface IUriNameConversion {
        public String convert(URI var1, String var2);
    }
}

