/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.PropertyBag;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.XmlHelper;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.secret.TokenType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TokenPair
extends Secret {
    private static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new LinkedHashMap(0));
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    public final Token AccessToken;
    public final Token RefreshToken;
    public final Map<String, String> Parameters;

    public TokenPair(String accessToken, String refreshToken) {
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(accessToken), "The accessToken parameter is null or invalid.");
        Debug.Assert(!StringHelper.isNullOrWhiteSpace(refreshToken), "The refreshToken parameter is null or invalid.");
        this.AccessToken = new Token(accessToken, TokenType.Access);
        this.RefreshToken = new Token(refreshToken, TokenType.Refresh);
        this.Parameters = EMPTY_MAP;
    }

    public TokenPair(String accessTokenResponse) {
        this(PropertyBag.fromJson(accessTokenResponse));
    }

    public TokenPair(PropertyBag bag) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        String accessToken = null;
        String refreshToken = null;
        for (Map.Entry pair : bag.entrySet()) {
            String name = (String)pair.getKey();
            Object value = pair.getValue();
            if (ACCESS_TOKEN.equals(name)) {
                accessToken = (String)value;
                continue;
            }
            if (REFRESH_TOKEN.equals(name)) {
                refreshToken = (String)value;
                continue;
            }
            parameters.put(name, value.toString());
        }
        this.AccessToken = new Token(accessToken, TokenType.Access);
        this.RefreshToken = new Token(refreshToken, TokenType.Refresh);
        this.Parameters = Collections.unmodifiableMap(parameters);
    }

    public static TokenPair fromXml(Node tokenPairNode) {
        String accessToken = null;
        String refreshToken = null;
        NodeList propertyNodes = tokenPairNode.getChildNodes();
        for (int v = 0; v < propertyNodes.getLength(); ++v) {
            Node propertyNode = propertyNodes.item(v);
            String propertyName = propertyNode.getNodeName();
            if ("accessToken".equals(propertyName)) {
                accessToken = XmlHelper.getText(propertyNode);
                continue;
            }
            if (!"refreshToken".equals(propertyName)) continue;
            refreshToken = XmlHelper.getText(propertyNode);
        }
        TokenPair value = new TokenPair(accessToken, refreshToken);
        return value;
    }

    public Element toXml(Document document) {
        Element valueNode = document.createElement("value");
        Element accessTokenNode = document.createElement("accessToken");
        Text accessTokenValue = document.createTextNode(this.AccessToken.Value);
        accessTokenNode.appendChild(accessTokenValue);
        valueNode.appendChild(accessTokenNode);
        Element refreshTokenNode = document.createElement("refreshToken");
        Text refreshTokenValue = document.createTextNode(this.RefreshToken.Value);
        refreshTokenNode.appendChild(refreshTokenValue);
        valueNode.appendChild(refreshTokenNode);
        return valueNode;
    }

    public static String toXmlString(TokenPair tokenPair) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = tokenPair.toXml(document);
            document.appendChild(element);
            String result = XmlHelper.toString(document);
            return result;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static TokenPair fromXmlString(String xmlString) {
        byte[] bytes = StringHelper.UTF8GetBytes(xmlString);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return TokenPair.fromXmlStream(inputStream);
    }

    static TokenPair fromXmlStream(InputStream source) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(source);
            Element rootElement = document.getDocumentElement();
            TokenPair result = TokenPair.fromXml(rootElement);
            return result;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object object) {
        return TokenPair.operatorEquals(this, object instanceof TokenPair ? (TokenPair)object : null);
    }

    public int hashCode() {
        return this.AccessToken.hashCode() * this.RefreshToken.hashCode();
    }

    public static boolean operatorEquals(TokenPair pair1, TokenPair pair2) {
        if (pair1 == pair2) {
            return true;
        }
        if (pair1 == null || null == pair2) {
            return false;
        }
        return Token.operatorEquals(pair1.AccessToken, pair2.AccessToken) && Token.operatorEquals(pair1.RefreshToken, pair2.RefreshToken);
    }

    public static boolean operatorNotEquals(TokenPair pair1, TokenPair pair2) {
        return !TokenPair.operatorEquals(pair1, pair2);
    }
}

