/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage;

import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.secret.Token;
import com.microsoft.alm.storage.InsecureFileBackend;
import com.microsoft.alm.storage.SecretStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsecureFileBackedTokenStore
implements SecretStore<Token> {
    private static Logger logger = LoggerFactory.getLogger(InsecureFileBackedTokenStore.class);
    private static InsecureFileBackend fileBackend = InsecureFileBackend.getInstance();

    @Override
    public Token get(String key) {
        return fileBackend.readToken(key);
    }

    @Override
    public boolean delete(String key) {
        return fileBackend.delete(key);
    }

    @Override
    public boolean add(String key, Token secret) {
        try {
            fileBackend.writeToken(key, secret);
            return true;
        }
        catch (Throwable t) {
            LoggingHelper.logError(logger, "Failed to add secret to file backed token store.", t);
            return false;
        }
    }

    @Override
    public boolean isSecure() {
        return false;
    }
}

