/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.core.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.common.ProjectState;
import com.microsoft.alm.core.webapi.model.ConnectedServiceKind;
import com.microsoft.alm.core.webapi.model.IdentityData;
import com.microsoft.alm.core.webapi.model.Process;
import com.microsoft.alm.core.webapi.model.Proxy;
import com.microsoft.alm.core.webapi.model.TeamProject;
import com.microsoft.alm.core.webapi.model.TeamProjectCollection;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.core.webapi.model.WebApiConnectedService;
import com.microsoft.alm.core.webapi.model.WebApiConnectedServiceDetails;
import com.microsoft.alm.core.webapi.model.WebApiTeam;
import com.microsoft.visualstudio.services.operations.OperationReference;
import com.microsoft.visualstudio.services.webapi.model.IdentityRef;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class CoreHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected CoreHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected CoreHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public WebApiConnectedService createConnectedService(WebApiConnectedServiceDetails connectedServiceCreationData, String projectId) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)connectedServiceCreationData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (WebApiConnectedService)super.sendRequest((Object)httpRequest, WebApiConnectedService.class);
    }

    public WebApiConnectedServiceDetails getConnectedServiceDetails(String projectId, String name) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        routeValues.put("name", name);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (WebApiConnectedServiceDetails)super.sendRequest((Object)httpRequest, WebApiConnectedServiceDetails.class);
    }

    public List<WebApiConnectedService> getConnectedServices(String projectId, ConnectedServiceKind kind) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("kind", (Object)kind);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<WebApiConnectedService>>(){});
    }

    public void createIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("mruName", mruName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)mruData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("mruName", mruName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public List<IdentityRef> getIdentityMru(String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("mruName", mruName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRef>>(){});
    }

    public void updateIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("mruName", mruName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)mruData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public List<IdentityRef> getTeamMembers(String projectId, String teamId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("294c494c-2600-4d7e-b76c-3dd50c3c95be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRef>>(){});
    }

    public Process getProcessById(UUID processId) {
        UUID locationId = UUID.fromString("93878975-88c5-4e6a-8abb-7ddd77a8a7d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("processId", processId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (Process)super.sendRequest((Object)httpRequest, Process.class);
    }

    public List<Process> getProcesses() {
        UUID locationId = UUID.fromString("93878975-88c5-4e6a-8abb-7ddd77a8a7d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Process>>(){});
    }

    public TeamProjectCollection getProjectCollection(String collectionId) {
        UUID locationId = UUID.fromString("8031090f-ef1d-4af6-85fc-698cd75d42bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("collectionId", collectionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (TeamProjectCollection)super.sendRequest((Object)httpRequest, TeamProjectCollection.class);
    }

    public List<TeamProjectCollectionReference> getProjectCollections(Integer top, Integer skip) {
        UUID locationId = UUID.fromString("8031090f-ef1d-4af6-85fc-698cd75d42bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TeamProjectCollectionReference>>(){});
    }

    public List<TeamProjectReference> getProjectHistory(Integer minRevision) {
        UUID locationId = UUID.fromString("6488a877-4749-4954-82ea-7340d36be9f2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("minRevision", (Object)minRevision);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TeamProjectReference>>(){});
    }

    public TeamProject getProject(String projectId, Boolean includeCapabilities, Boolean includeHistory) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCapabilities", (Object)includeCapabilities);
        queryParameters.addIfNotNull("includeHistory", (Object)includeHistory);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TeamProject)super.sendRequest((Object)httpRequest, TeamProject.class);
    }

    public List<TeamProjectReference> getProjects(ProjectState stateFilter, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("stateFilter", (Object)stateFilter);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TeamProjectReference>>(){});
    }

    public OperationReference queueCreateProject(TeamProject projectToCreate) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)projectToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (OperationReference)super.sendRequest((Object)httpRequest, OperationReference.class);
    }

    public OperationReference queueDeleteProject(UUID projectId) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (OperationReference)super.sendRequest((Object)httpRequest, OperationReference.class);
    }

    public OperationReference updateProject(TeamProject projectUpdate, UUID projectId) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)projectUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (OperationReference)super.sendRequest((Object)httpRequest, OperationReference.class);
    }

    public List<Proxy> getProxies(String proxyUrl) {
        UUID locationId = UUID.fromString("ec1f4311-f2b4-4c15-b2b8-8990b80d2908");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("proxyUrl", proxyUrl);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<Proxy>>(){});
    }

    public WebApiTeam getTeams(String projectId, String teamId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (WebApiTeam)super.sendRequest((Object)httpRequest, WebApiTeam.class);
    }
}

