/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.visualstudio.services.webapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.alm.client.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VssJsonCollectionWrapper<T> {
    private int count;
    private T value;

    public VssJsonCollectionWrapper() {
    }

    public VssJsonCollectionWrapper(T value) {
        this.value = value;
        if (value == null) {
            this.count = 0;
        } else if (value instanceof List) {
            this.count = ((List)value).size();
        } else if (value instanceof Collection) {
            this.count = ((Collection)value).size();
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("VssJsonCollectionWrapper.CannotWrapFormat"), value.getClass().getName()));
        }
    }

    @JsonProperty(value="value")
    public T getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(T value) {
        this.value = value;
    }

    @JsonProperty(value="count")
    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    public void setCount(int count) {
        this.count = count;
    }

    public static <T> VssJsonCollectionWrapper<List<T>> newInstance(List<T> value) {
        ArrayList<T> newValue = new ArrayList<T>();
        newValue.addAll(value);
        return new VssJsonCollectionWrapper<List<T>>(newValue);
    }
}

