/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSFileType;
import org.jetbrains.plugins.less.psi.LESSFile;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LESSElementGenerator {
    @Nullable
    public static LESSVariableImpl createVariable(Project project, String text) {
        return (LESSVariableImpl)PsiTreeUtil.findChildOfType((PsiElement)LESSElementGenerator.createFileFromText(project, "#header.fake {\n fake: " + text + ";\n}"), LESSVariableImpl.class);
    }

    @Nullable
    public static LESSMixinName createMixinName(Project project, String fullName) {
        return (LESSMixinName)PsiTreeUtil.findChildOfType((PsiElement)LESSElementGenerator.createFileFromText(project, fullName + "() {}"), LESSMixinName.class);
    }

    @Nullable
    public static LESSNamespace createNamespace(Project project, String name) {
        return (LESSNamespace)PsiTreeUtil.findChildOfType((PsiElement)LESSElementGenerator.createFileFromText(project, name + " > .fakeMixin();"), LESSNamespace.class);
    }

    @NotNull
    private static LESSFile createFileFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/less/psi/LESSElementGenerator", "createFileFromText"));
        }
        LESSFile lESSFile = (LESSFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.less", (FileType)LESSFileType.LESS, (CharSequence)text);
        if (lESSFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/LESSElementGenerator", "createFileFromText"));
        }
        return lESSFile;
    }

    @Nullable
    public static LESSVariableImpl createVariableInInterpolation(Project project, String name) {
        name = StringUtil.startsWithChar((CharSequence)name, (char)'@') ? name.substring(1) : name;
        return (LESSVariableImpl)PsiTreeUtil.findChildOfType((PsiElement)LESSElementGenerator.createFileFromText(project, "#@{" + name + "} {}"), LESSVariableImpl.class);
    }
}

