/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class HttpHeadersDictionary {
    private static Set<String> ourHeaders;

    public static Collection<String> getHeaders() {
        if (ourHeaders == null) {
            ourHeaders = HttpHeadersDictionary.readHeaders();
        }
        return ourHeaders;
    }

    private static Set<String> readHeaders() {
        TreeSet<String> result = new TreeSet<String>();
        Collections.addAll(result, HtmlUtil.RFC2616_HEADERS);
        HttpHeadersDictionary.readHeadersFile(result, "/com/intellij/ws/rest/client/perm-headers.csv");
        HttpHeadersDictionary.readHeadersFile(result, "/com/intellij/ws/rest/client/prov-headers.csv");
        return result;
    }

    private static void readHeadersFile(Collection<String> result, String path) {
        InputStream stream = HttpHeadersDictionary.class.getResourceAsStream(path);
        String csv = "";
        try {
            csv = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : "";
        }
        catch (IOException e) {
            Logger.getInstance(HttpHeadersDictionary.class).error((Throwable)e);
        }
        for (String line : StringUtil.splitByLines((String)csv)) {
            String[] split = line.split(",");
            if (split.length <= 2 || !"http".equals(split[2])) continue;
            result.add(split[0]);
        }
    }
}

