/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.client;

import com.google.common.io.CountingInputStream;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientController;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponseListener;
import com.intellij.ws.rest.client.RestClientSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientControllerImpl
implements RestClientController {
    private static final Logger LOG = Logger.getInstance(RestClientControllerImpl.class);
    @NonNls
    private static final String EMPTY_RESPONSE = "<Response body is empty>";
    private static final StringBuffer EMPTY_BUFFER = new StringBuffer();
    private final Project project;

    public RestClientControllerImpl(Project project) {
        this.project = project;
    }

    @Override
    public void onGoButtonClick(final RestClientRequest request, final RestClientResponseListener responseListener, final RestClientRequestProcessor ... processors) {
        FileDocumentManager.getInstance().saveAllDocuments();
        for (RestClientRequestProcessor processor : processors) {
            processor.preProcessRequest(request);
        }
        responseListener.setResponse("", "text/plain");
        responseListener.setResponseHeader("");
        responseListener.setStatus("");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.project, RestClientBundle.message("accessing.url", request.getURL()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/rest/client/RestClientControllerImpl$1", "run"));
                }
                BasicCookieStore store = new BasicCookieStore();
                try {
                    int len;
                    HttpEntity entity;
                    InputStream body;
                    Long length;
                    String url = request.getURL();
                    RestClientControllerImpl.biscuitsToCookies(request, store);
                    CloseableHttpClient client = RestClientControllerImpl.createHttpClient(url, (CookieStore)store);
                    HttpRequestBase method = RestClientControllerImpl.createHttpMethod(url, request);
                    RestClientControllerImpl.addHeaders(method, request);
                    RestClientControllerImpl.initParameters(method, request);
                    long start = System.currentTimeMillis();
                    CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> 1.lambda$run$0(responseListener, (HttpResponse)response, start));
                    Header contentLength = response.getFirstHeader("Content-Length");
                    Long l = length = contentLength == null ? null : RestClientControllerImpl.fromString(contentLength.getValue());
                    if (length != null) {
                        indicator.setIndeterminate(false);
                        indicator.setText("Accessing resource");
                        indicator.setFraction(0.0);
                    }
                    InputStream inputStream = body = (entity = response.getEntity()) == null ? null : entity.getContent();
                    if (body == null) {
                        ApplicationManager.getApplication().invokeLater(() -> 1.lambda$run$1((HttpResponse)response, responseListener, start, store));
                        return;
                    }
                    CountingInputStream countingInputStream = new CountingInputStream(body);
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    Charset charset = contentType.getCharset();
                    if (charset == null) {
                        charset = HTTP.DEF_CONTENT_CHARSET;
                    }
                    InputStreamReader reader = new InputStreamReader((InputStream)countingInputStream, charset);
                    char[] b = new char[4096];
                    StringBuffer buf = new StringBuffer();
                    while ((len = reader.read(b)) != -1 && !indicator.isCanceled()) {
                        buf.append(new String(b, 0, len));
                        if (length == null) continue;
                        indicator.setText(countingInputStream.getCount() / 1000L + " of " + length / 1000L + "Kb");
                        indicator.setFraction((double)countingInputStream.getCount() / (double)length.longValue());
                    }
                    ApplicationManager.getApplication().invokeLater(() -> 1.lambda$run$2(buf, (HttpResponse)response, responseListener, start, store));
                    RestClientSettings.getInstance(RestClientControllerImpl.this.project).addToHistory(request);
                }
                catch (Exception ex) {
                    LOG.info((Throwable)ex);
                    for (RestClientRequestProcessor processor : processors) {
                        processor.postProcessRequest(request, (CookieStore)store);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> responseListener.setResponse(ex.toString(), "text/plain"));
                }
            }

            private static /* synthetic */ void lambda$run$2(StringBuffer buf, HttpResponse response, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.showResponse(buf, response, responseListener2, start, (CookieStore)store);
            }

            private static /* synthetic */ void lambda$run$1(HttpResponse response, RestClientResponseListener responseListener2, long start, BasicCookieStore store) {
                RestClientControllerImpl.showResponse(EMPTY_BUFFER, response, responseListener2, start, (CookieStore)store);
            }

            private static /* synthetic */ void lambda$run$0(RestClientResponseListener responseListener2, HttpResponse response, long start) {
                responseListener2.setStatus(RestClientControllerImpl.getStatusText(response, start));
            }
        });
    }

    private static void biscuitsToCookies(RestClientRequest request, BasicCookieStore store) {
        for (RestClientRequest.Biscuit biscuit : request.biscuits) {
            BasicClientCookie cookie = new BasicClientCookie(biscuit.getName(), biscuit.getValue());
            if (biscuit.getDomain() != null) {
                cookie.setDomain(biscuit.getDomain());
            }
            if (biscuit.getPath() != null) {
                cookie.setPath(biscuit.getPath());
            }
            if (biscuit.getDate() != -1L) {
                cookie.setExpiryDate(new Date(biscuit.getDate()));
            }
            store.addCookie((Cookie)cookie);
        }
    }

    private static void showResponse(StringBuffer buf, HttpResponse response, RestClientResponseListener responseListener, long start, CookieStore cookies) {
        if (buf.length() == 0) {
            responseListener.setResponse(EMPTY_RESPONSE, "text/plain");
        } else {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
            responseListener.setResponse(buf.toString(), contentType.getMimeType());
        }
        String text = RestClientControllerImpl.getStatusText(response, start);
        text = text + "; Content length: " + buf.length() + " bytes";
        responseListener.setStatus(text);
        responseListener.setResponseHeader(response.getStatusLine().toString() + "\n" + RestClientControllerImpl.toString(response.getAllHeaders()));
        responseListener.setCookies(cookies.getCookies());
    }

    private static String getStatusText(HttpResponse response, long start) {
        String text = "Response code: " + response.getStatusLine().getStatusCode();
        String status = response.getStatusLine().getReasonPhrase();
        if (status != null && status.length() > 0) {
            text = text + " (" + status + ")";
        }
        text = text + "; Time: " + (System.currentTimeMillis() - start) + "ms";
        return text;
    }

    private static void addHeaders(HttpRequestBase method, RestClientRequest request) {
        for (RestClientRequest.KeyValuePair header : request.headers) {
            method.addHeader(header.getKey(), header.getValue());
        }
    }

    private static String toString(Header[] headers) {
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            builder.append(header.toString()).append("\n");
        }
        return builder.toString();
    }

    private static CloseableHttpClient createHttpClient(String url, CookieStore cookieStore) {
        HttpClientBuilder client = HttpClients.custom();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        client.setDefaultCredentialsProvider((CredentialsProvider)provider);
        try {
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(CertificateManager.getInstance().getSslContext(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry registry = RegistryBuilder.create().register("https", (Object)factory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            client.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        client.addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding());
        client.setDefaultCookieStore(cookieStore);
        try {
            HttpConfigurable proxyConfigurable;
            List<Proxy> proxies;
            InetSocketAddress address;
            URI uri = new URI(url);
            String userinfo = uri.getUserInfo();
            if (userinfo != null && userinfo.length() > 0) {
                provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userinfo));
            }
            InetSocketAddress inetSocketAddress = address = (proxies = (proxyConfigurable = HttpConfigurable.getInstance()).getOnlyBySettingsSelector().select(uri)).size() > 0 ? (InetSocketAddress)proxies.get(0).address() : null;
            if (address != null) {
                client.setProxy(new HttpHost(address.getHostName(), address.getPort()));
                IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)provider);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return client.build();
    }

    private static void initParameters(HttpRequestBase httpMethod, RestClientRequest request) throws IOException {
        if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase method = (HttpEntityEnclosingRequestBase)httpMethod;
            if (request.haveTextToSend) {
                ContentType contentType = ContentType.parse((String)RestClientControllerImpl.getContentType(request));
                if (contentType.getCharset() == null) {
                    contentType = contentType.withCharset(RestClientControllerImpl.getEncoding(request));
                }
                method.setEntity((HttpEntity)new StringEntity(request.textToSend, contentType));
            } else if (request.haveFileToSend) {
                List<File> files = request.getFiles();
                if (request.isFileUpload) {
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    for (File file : files) {
                        builder.addPart(file.getName(), (ContentBody)new FileBody(file));
                    }
                    method.setEntity(builder.build());
                } else if (files.size() > 0) {
                    method.setEntity((HttpEntity)new FileEntity(files.get(0), ContentType.create((String)RestClientControllerImpl.getContentType(request))));
                }
            }
        }
    }

    private static String getContentType(RestClientRequest request) {
        return request.getHeaderValue("Content-Type", "*/*");
    }

    private static String getEncoding(RestClientRequest request) {
        return request.getHeaderValue("Accept-Charset", "UTF-8");
    }

    @Override
    public boolean isValidURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static HttpRequestBase createHttpMethod(String uri, final RestClientRequest request) {
        String query;
        if (request.parametersEnabled && (!"POST".equals(request.httpMethod) || request.haveFileToSend || request.haveTextToSend) && StringUtil.isNotEmpty((String)(query = request.createQueryString()))) {
            uri = uri + (uri.contains("?") ? "&" : "?") + query;
        }
        if ("GET".equals(request.httpMethod)) {
            return new HttpGet(uri);
        }
        if ("HEAD".equals(request.httpMethod)) {
            return new HttpHead(uri);
        }
        if ("DELETE".equals(request.httpMethod)) {
            return new HttpDelete(uri);
        }
        if ("PUT".equals(request.httpMethod)) {
            return new HttpPut(uri);
        }
        if ("PATCH".equals(request.httpMethod)) {
            return new HttpPatch(uri);
        }
        if ("TRACE".equals(request.httpMethod)) {
            return new HttpTrace(uri);
        }
        if ("OPTIONS".equals(request.httpMethod)) {
            return new HttpOptions(uri);
        }
        if ("POST".equals(request.httpMethod)) {
            HttpPost method = new HttpPost(uri);
            if (request.parametersEnabled) {
                ArrayList<BasicNameValuePair> entities = new ArrayList<BasicNameValuePair>();
                for (RestClientRequest.KeyValuePair parameter : request.parameters) {
                    entities.add(new BasicNameValuePair(parameter.getKey(), parameter.getValue()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(entities, Charset.defaultCharset());
                method.setEntity((HttpEntity)entity);
            }
            return method;
        }
        final String finalUri = uri;
        return new HttpRequestBase(){
            {
                this.setURI(URI.create(finalUri));
            }

            public String getMethod() {
                return request.httpMethod;
            }
        };
    }

    @Override
    public void openResponseInBrowser(String response) {
        try {
            File file = FileUtil.createTempFile((String)"tmpRestClientResponse", (String)".html");
            FileWriter fw = new FileWriter(file);
            fw.write(response);
            fw.close();
            BrowserUtil.browse((URI)file.toURI());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    private static Long fromString(String num) {
        try {
            return new Long(num);
        }
        catch (Exception e) {
            return null;
        }
    }
}

