/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.sourcecontrol.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.sourcecontrol.webapi.model.AssociatedWorkItem;
import com.microsoft.alm.sourcecontrol.webapi.model.GitBaseVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.GitBlobRef;
import com.microsoft.alm.sourcecontrol.webapi.model.GitBranchStats;
import com.microsoft.alm.sourcecontrol.webapi.model.GitCommit;
import com.microsoft.alm.sourcecontrol.webapi.model.GitCommitChanges;
import com.microsoft.alm.sourcecontrol.webapi.model.GitCommitDiffs;
import com.microsoft.alm.sourcecontrol.webapi.model.GitCommitRef;
import com.microsoft.alm.sourcecontrol.webapi.model.GitItem;
import com.microsoft.alm.sourcecontrol.webapi.model.GitItemRequestData;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequestSearchCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPush;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPushSearchCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.GitQueryCommitsCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRef;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRefUpdate;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRefUpdateResult;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import com.microsoft.alm.sourcecontrol.webapi.model.GitTargetVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.GitTreeRef;
import com.microsoft.alm.sourcecontrol.webapi.model.GitVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.IdentityRefWithVote;
import com.microsoft.alm.sourcecontrol.webapi.model.VersionControlRecursionType;
import com.microsoft.visualstudio.services.webapi.model.IdentityRef;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class GitHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected GitHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected GitHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public GitBlobRef getBlob(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public GitBlobRef getBlob(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBlobRef)super.sendRequest((Object)httpRequest, GitBlobRef.class);
    }

    public InputStream getBlobContent(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobContent(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String project, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, String project, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID project, String repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobsZip(List<String> blobIds, UUID project, UUID repositoryId, String filename) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filename", filename);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, blobIds, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID project, String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID project, UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(String repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getBlobZip(UUID repositoryId, String sha1, Boolean download, String fileName) {
        UUID locationId = UUID.fromString("7b28e929-2c99-405d-9c5c-6167a06e6816");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public GitBranchStats getBranch(String project, String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(String project, UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID project, String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID project, UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(String repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public GitBranchStats getBranch(UUID repositoryId, String name, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitBranchStats)super.sendRequest((Object)httpRequest, GitBranchStats.class);
    }

    public List<GitBranchStats> getBranches(String project, String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public List<GitBranchStats> getBranches(String project, UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public List<GitBranchStats> getBranches(UUID project, String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public List<GitBranchStats> getBranches(UUID project, UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public List<GitBranchStats> getBranches(String repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public List<GitBranchStats> getBranches(UUID repositoryId, GitVersionDescriptor baseVersionDescriptor) {
        UUID locationId = UUID.fromString("d5b216de-d8d5-4d32-ae76-51df755b16d3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitBranchStats>>(){});
    }

    public GitCommitChanges getChanges(String project, String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String project, String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(UUID project, String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(UUID project, String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String commitId, String repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitChanges getChanges(String commitId, UUID repositoryId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("5bf884f5-3e07-42e9-afb8-1b872267bf16");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitChanges)super.sendRequest((Object)httpRequest, GitCommitChanges.class);
    }

    public GitCommitDiffs getCommitDiffs(String project, String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(String project, UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID project, String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID project, UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(String repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommitDiffs getCommitDiffs(UUID repositoryId, Boolean diffCommonCommit, Integer top, Integer skip, GitBaseVersionDescriptor baseVersionDescriptor, GitTargetVersionDescriptor targetVersionDescriptor) {
        UUID locationId = UUID.fromString("615588d5-c0c7-4b88-88f8-e625306446e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("diffCommonCommit", (Object)diffCommonCommit);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        this.addModelAsQueryParams(queryParameters, baseVersionDescriptor);
        this.addModelAsQueryParams(queryParameters, targetVersionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommitDiffs)super.sendRequest((Object)httpRequest, GitCommitDiffs.class);
    }

    public GitCommit getCommit(String project, String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String project, String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(UUID project, String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(UUID project, String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String commitId, String repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public GitCommit getCommit(String commitId, UUID repositoryId, Integer changeCount) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("commitId", commitId);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeCount", (Object)changeCount);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitCommit)super.sendRequest((Object)httpRequest, GitCommit.class);
    }

    public List<GitCommitRef> getCommits(String project, String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommits(String project, UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommits(UUID project, String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommits(UUID project, UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommits(String repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommits(UUID repositoryId, GitQueryCommitsCriteria searchCriteria, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(String project, String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(String project, UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(UUID project, String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(UUID project, UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(String repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPushCommits(UUID repositoryId, int pushId, Integer top, Integer skip, Boolean includeLinks) {
        UUID locationId = UUID.fromString("c2570c3b-5b3f-41b8-98bf-5407bfde8d58");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"pushId", (Object)String.valueOf(pushId));
        queryParameters.addIfNotNull("top", (Object)top);
        queryParameters.addIfNotNull("skip", (Object)skip);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String project, String repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, String project, UUID repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID project, String repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getCommitsBatch(GitQueryCommitsCriteria searchCriteria, UUID project, UUID repositoryId, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("6400dfb2-0bcb-462b-b992-5a57f8f1416c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)searchCriteria, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public GitItem getItem(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public GitItem getItem(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public GitItem getItem(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public GitItem getItem(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitItem)super.sendRequest((Object)httpRequest, GitItem.class);
    }

    public InputStream getItemContent(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<GitItem> getItems(String project, String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public List<GitItem> getItems(String project, UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public List<GitItem> getItems(UUID project, String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public List<GitItem> getItems(UUID project, UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public List<GitItem> getItems(String repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public List<GitItem> getItems(UUID repositoryId, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, Boolean includeLinks, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitItem>>(){});
    }

    public InputStream getItemText(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID repositoryId, String path, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeContentMetadata, Boolean latestProcessedChange, Boolean download, GitVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("fb93c0db-47ed-4a31-8c20-47552878fb44");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeContentMetadata", (Object)includeContentMetadata);
        queryParameters.addIfNotNull("latestProcessedChange", (Object)latestProcessedChange);
        queryParameters.addIfNotNull("download", (Object)download);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, String project, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<List<GitItem>> getItemsBatch(GitItemRequestData requestData, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("630fd2e4-fb88-4f85-ad21-13f3fd1fbca9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)requestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<GitItem>>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public List<GitCommitRef> getPullRequestCommits(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("52823034-34a8-4576-922c-8d8b77e9e4c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitCommitRef>>(){});
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote createPullRequestReviewer(IdentityRefWithVote reviewer, UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)reviewer, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> createPullRequestReviewers(IdentityRef[] reviewers, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)reviewers, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public void deletePullRequestReviewer(String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deletePullRequestReviewer(UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deletePullRequestReviewer(String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deletePullRequestReviewer(String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deletePullRequestReviewer(UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deletePullRequestReviewer(UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public IdentityRefWithVote getPullRequestReviewer(String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote getPullRequestReviewer(String project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote getPullRequestReviewer(String project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID project, String repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public IdentityRefWithVote getPullRequestReviewer(UUID project, UUID repositoryId, int pullRequestId, String reviewerId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        routeValues.put("reviewerId", reviewerId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (IdentityRefWithVote)((Object)super.sendRequest((Object)httpRequest, IdentityRefWithVote.class));
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public List<IdentityRefWithVote> getPullRequestReviewers(UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("4b6702c7-aa35-4b89-9c96-b9abf6d3e540");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRefWithVote>>(){});
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String project, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest createPullRequest(GitPullRequest gitPullRequestToCreate, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitPullRequestToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String project, String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String project, UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID project, String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID project, UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(String repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest getPullRequest(UUID repositoryId, int pullRequestId, Integer maxCommentLength, Integer skip, Integer top, Boolean includeCommits) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public List<GitPullRequest> getPullRequests(String project, String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequests(String project, UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequests(UUID project, String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequests(UUID project, UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequests(String repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequests(UUID repositoryId, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, String project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID project, String repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public GitPullRequest updatePullRequest(GitPullRequest gitPullRequestToUpdate, UUID project, UUID repositoryId, int pullRequestId) {
        UUID locationId = UUID.fromString("9946fd70-0d40-406e-b686-b4744cbbcc37");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)gitPullRequestToUpdate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPullRequest)super.sendRequest((Object)httpRequest, GitPullRequest.class);
    }

    public List<GitPullRequest> getPullRequestsByProject(String project, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("a5d28130-9cd2-40fa-9f08-902e7daa9efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<GitPullRequest> getPullRequestsByProject(UUID project, GitPullRequestSearchCriteria searchCriteria, Integer maxCommentLength, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("a5d28130-9cd2-40fa-9f08-902e7daa9efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPullRequest>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(String project, String repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(String project, UUID repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(UUID project, String repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(UUID project, UUID repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(String repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", pullRequestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<AssociatedWorkItem> getPullRequestWorkItems(UUID repositoryId, int pullRequestId, Integer commitsTop, Integer commitsSkip) {
        UUID locationId = UUID.fromString("0a637fcc-5370-4ce8-b0e8-98091f5f9482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pullRequestId", Integer.valueOf(pullRequestId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("commitsTop", (Object)commitsTop);
        queryParameters.addIfNotNull("commitsSkip", (Object)commitsSkip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public GitPush createPush(GitPush push, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, String project, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush createPush(GitPush push, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)push, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(String project, String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(String project, UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID project, String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID project, UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", Integer.valueOf(pushId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(String repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", pushId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public GitPush getPush(UUID repositoryId, int pushId, Integer includeCommits, Boolean includeRefUpdates) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("pushId", Integer.valueOf(pushId));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCommits", (Object)includeCommits);
        queryParameters.addIfNotNull("includeRefUpdates", (Object)includeRefUpdates);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitPush)super.sendRequest((Object)httpRequest, GitPush.class);
    }

    public List<GitPush> getPushes(String project, String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitPush> getPushes(String project, UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitPush> getPushes(UUID project, String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitPush> getPushes(UUID project, UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitPush> getPushes(String repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitPush> getPushes(UUID repositoryId, Integer skip, Integer top, GitPushSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("ea98d07b-3c87-4971-8ede-a613694ffb55");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitPush>>(){});
    }

    public List<GitRef> getRefs(String project, String repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRef> getRefs(String project, UUID repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRef> getRefs(UUID project, String repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRef> getRefs(UUID project, UUID repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRef> getRefs(String repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRef> getRefs(UUID repositoryId, String filter, Boolean includeLinks) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("filter", filter);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRef>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String project, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, String project, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID project, String repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public List<GitRefUpdateResult> updateRefs(List<GitRefUpdate> refUpdates, UUID project, UUID repositoryId, String projectId) {
        UUID locationId = UUID.fromString("2d874a60-a811-4f62-9c9f-963a6ea0a55b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, refUpdates, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRefUpdateResult>>(){});
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)gitRepositoryToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate, String project) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitRepositoryToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository createRepository(GitRepository gitRepositoryToCreate, UUID project) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)gitRepositoryToCreate, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public void deleteRepository(UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteRepository(String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteRepository(UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public List<GitRepository> getRepositories(String project, Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRepository>>(){});
    }

    public List<GitRepository> getRepositories(UUID project, Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRepository>>(){});
    }

    public List<GitRepository> getRepositories(Boolean includeLinks) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<GitRepository>>(){});
    }

    public GitRepository getRepository(String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(String project, String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID project, String repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository getRepository(UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)newRepositoryInfo, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, String project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)newRepositoryInfo, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitRepository updateRepository(GitRepository newRepositoryInfo, UUID project, UUID repositoryId) {
        UUID locationId = UUID.fromString("225f7195-f9c7-4d14-ab28-a83f7ff77e1f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)newRepositoryInfo, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (GitRepository)super.sendRequest((Object)httpRequest, GitRepository.class);
    }

    public GitTreeRef getTree(String project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(String project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public GitTreeRef getTree(UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (GitTreeRef)super.sendRequest((Object)httpRequest, GitTreeRef.class);
    }

    public InputStream getTreeZip(String project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(String project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID project, String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID project, UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(String repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getTreeZip(UUID repositoryId, String sha1, String projectId, Boolean recursive, String fileName) {
        UUID locationId = UUID.fromString("729f6437-6f92-44ec-8bee-273a7111063c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("repositoryId", repositoryId);
        routeValues.put("sha1", sha1);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("projectId", projectId);
        queryParameters.addIfNotNull("recursive", (Object)recursive);
        queryParameters.addIfNotEmpty("fileName", fileName);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }
}

