/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.sourcecontrol.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.sourcecontrol.webapi.model.AssociatedWorkItem;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcBranch;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcBranchRef;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcChange;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcChangeset;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcChangesetRef;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcChangesetSearchCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcChangesetsRequestData;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcItem;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcItemRequestData;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcLabel;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcLabelRef;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcLabelRequestData;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcShelveset;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcShelvesetRef;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcShelvesetRequestData;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcVersionDescriptor;
import com.microsoft.alm.sourcecontrol.webapi.model.VersionControlProjectInfo;
import com.microsoft.alm.sourcecontrol.webapi.model.VersionControlRecursionType;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class TfvcHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TfvcHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected TfvcHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public TfvcBranch getBranch(String project, String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcBranch)super.sendRequest((Object)httpRequest, TfvcBranch.class);
    }

    public TfvcBranch getBranch(UUID project, String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcBranch)super.sendRequest((Object)httpRequest, TfvcBranch.class);
    }

    public TfvcBranch getBranch(String path, Boolean includeParent, Boolean includeChildren) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcBranch)super.sendRequest((Object)httpRequest, TfvcBranch.class);
    }

    public List<TfvcBranch> getBranches(String project, Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranch>>(){});
    }

    public List<TfvcBranch> getBranches(UUID project, Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranch>>(){});
    }

    public List<TfvcBranch> getBranches(Boolean includeParent, Boolean includeChildren, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeParent", (Object)includeParent);
        queryParameters.addIfNotNull("includeChildren", (Object)includeChildren);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranch>>(){});
    }

    public List<TfvcBranchRef> getBranchRefs(String project, String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranchRef>>(){});
    }

    public List<TfvcBranchRef> getBranchRefs(UUID project, String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranchRef>>(){});
    }

    public List<TfvcBranchRef> getBranchRefs(String scopePath, Boolean includeDeleted, Boolean includeLinks) {
        UUID locationId = UUID.fromString("bc1f417e-239d-42e7-85e1-76e80cb2d6eb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("includeDeleted", (Object)includeDeleted);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcBranchRef>>(){});
    }

    public List<TfvcChange> getChangesetChanges(Integer id, Integer skip, Integer top) {
        UUID locationId = UUID.fromString("f32b86f2-15b9-4fe6-81b1-6f8938617ee5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChange>>(){});
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)changeset, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TfvcChangesetRef)super.sendRequest((Object)httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset, String project) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)changeset, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TfvcChangesetRef)super.sendRequest((Object)httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangesetRef createChangeset(TfvcChangeset changeset, UUID project) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)changeset, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TfvcChangesetRef)super.sendRequest((Object)httpRequest, TfvcChangesetRef.class);
    }

    public TfvcChangeset getChangeset(String project, int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcChangeset)super.sendRequest((Object)httpRequest, TfvcChangeset.class);
    }

    public TfvcChangeset getChangeset(UUID project, int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<UUID>> routeValues = new HashMap<String, Comparable<UUID>>();
        routeValues.put("project", project);
        routeValues.put("id", Integer.valueOf(id));
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcChangeset)super.sendRequest((Object)httpRequest, TfvcChangeset.class);
    }

    public TfvcChangeset getChangeset(int id, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcChangeset)super.sendRequest((Object)httpRequest, TfvcChangeset.class);
    }

    public List<TfvcChangesetRef> getChangesets(String project, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChangesetRef>>(){});
    }

    public List<TfvcChangesetRef> getChangesets(UUID project, Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChangesetRef>>(){});
    }

    public List<TfvcChangesetRef> getChangesets(Integer maxChangeCount, Boolean includeDetails, Boolean includeWorkItems, Integer maxCommentLength, Boolean includeSourceRename, Integer skip, Integer top, String orderby, TfvcChangesetSearchCriteria searchCriteria) {
        UUID locationId = UUID.fromString("0bc8f0a4-6bfb-42a9-ba84-139da7b99c49");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("maxChangeCount", (Object)maxChangeCount);
        queryParameters.addIfNotNull("includeDetails", (Object)includeDetails);
        queryParameters.addIfNotNull("includeWorkItems", (Object)includeWorkItems);
        queryParameters.addIfNotNull("maxCommentLength", (Object)maxCommentLength);
        queryParameters.addIfNotNull("includeSourceRename", (Object)includeSourceRename);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotEmpty("$orderby", orderby);
        this.addModelAsQueryParams(queryParameters, searchCriteria);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChangesetRef>>(){});
    }

    public List<TfvcChangesetRef> getBatchedChangesets(TfvcChangesetsRequestData changesetsRequestData) {
        UUID locationId = UUID.fromString("b7e7c173-803c-4fea-9ec8-31ee35c5502a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)changesetsRequestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChangesetRef>>(){});
    }

    public List<AssociatedWorkItem> getChangesetWorkItems(Integer id) {
        UUID locationId = UUID.fromString("64ae0bea-1d71-47c9-a9e5-fe73f5ea0ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("id", id);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }

    public List<List<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)itemRequestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<TfvcItem>>>(){});
    }

    public List<List<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData, String project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)itemRequestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<TfvcItem>>>(){});
    }

    public List<List<TfvcItem>> getItemsBatch(TfvcItemRequestData itemRequestData, UUID project) {
        UUID locationId = UUID.fromString("fe6f827b-5f64-480f-b8af-1eca3b80e833");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)itemRequestData, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<List<TfvcItem>>>(){});
    }

    public TfvcItem getItem(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcItem)super.sendRequest((Object)httpRequest, TfvcItem.class);
    }

    public TfvcItem getItem(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcItem)super.sendRequest((Object)httpRequest, TfvcItem.class);
    }

    public TfvcItem getItem(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcItem)super.sendRequest((Object)httpRequest, TfvcItem.class);
    }

    public InputStream getItemContent(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemContent(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_OCTET_STREAM_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<TfvcItem> getItems(String project, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcItem>>(){});
    }

    public List<TfvcItem> getItems(UUID project, String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcItem>>(){});
    }

    public List<TfvcItem> getItems(String scopePath, VersionControlRecursionType recursionLevel, Boolean includeLinks, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        queryParameters.addIfNotNull("includeLinks", (Object)includeLinks);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcItem>>(){});
    }

    public InputStream getItemText(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemText(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, TEXT_PLAIN_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(UUID project, String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public InputStream getItemZip(String path, String fileName, Boolean download, String scopePath, VersionControlRecursionType recursionLevel, TfvcVersionDescriptor versionDescriptor) {
        UUID locationId = UUID.fromString("ba9fc436-9a38-4578-89d6-e4f3241f5040");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotNull("download", (Object)download);
        queryParameters.addIfNotEmpty("scopePath", scopePath);
        queryParameters.addIfNotNull("recursionLevel", (Object)recursionLevel);
        this.addModelAsQueryParams(queryParameters, versionDescriptor);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<TfvcItem> getLabelItems(String labelId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("06166e34-de17-4b60-8cd1-23182a346fda");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcItem>>(){});
    }

    public TfvcLabel getLabel(String project, String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcLabel)super.sendRequest((Object)httpRequest, TfvcLabel.class);
    }

    public TfvcLabel getLabel(UUID project, String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcLabel)super.sendRequest((Object)httpRequest, TfvcLabel.class);
    }

    public TfvcLabel getLabel(String labelId, TfvcLabelRequestData requestData) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("labelId", labelId);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcLabel)super.sendRequest((Object)httpRequest, TfvcLabel.class);
    }

    public List<TfvcLabelRef> getLabels(String project, TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcLabelRef>>(){});
    }

    public List<TfvcLabelRef> getLabels(UUID project, TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcLabelRef>>(){});
    }

    public List<TfvcLabelRef> getLabels(TfvcLabelRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("a5d9bd7f-b661-4d0e-b9be-d9c16affae54");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcLabelRef>>(){});
    }

    public VersionControlProjectInfo getProjectInfo(String project, UUID projectId) {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("projectId", (Object)projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (VersionControlProjectInfo)super.sendRequest((Object)httpRequest, VersionControlProjectInfo.class);
    }

    public VersionControlProjectInfo getProjectInfo(UUID project, UUID projectId) {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("projectId", (Object)projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (VersionControlProjectInfo)super.sendRequest((Object)httpRequest, VersionControlProjectInfo.class);
    }

    public VersionControlProjectInfo getProjectInfo(UUID projectId) {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("projectId", (Object)projectId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (VersionControlProjectInfo)super.sendRequest((Object)httpRequest, VersionControlProjectInfo.class);
    }

    public List<VersionControlProjectInfo> getProjectInfos() {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<VersionControlProjectInfo>>(){});
    }

    public List<VersionControlProjectInfo> getProjectInfos(String project) {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<VersionControlProjectInfo>>(){});
    }

    public List<VersionControlProjectInfo> getProjectInfos(UUID project) {
        UUID locationId = UUID.fromString("252d9c40-0643-41cf-85b2-044d80f9b675");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("project", project);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<VersionControlProjectInfo>>(){});
    }

    public List<TfvcChange> getShelvesetChanges(String shelvesetId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("dbaf075b-0445-4c34-9e5b-82292f856522");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcChange>>(){});
    }

    public TfvcShelveset getShelveset(String shelvesetId, TfvcShelvesetRequestData requestData) {
        UUID locationId = UUID.fromString("e36d44fb-e907-4b0a-b194-f83f1ed32ad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        this.addModelAsQueryParams(queryParameters, requestData);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TfvcShelveset)super.sendRequest((Object)httpRequest, TfvcShelveset.class);
    }

    public List<TfvcShelvesetRef> getShelvesets(TfvcShelvesetRequestData requestData, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("e36d44fb-e907-4b0a-b194-f83f1ed32ad3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        this.addModelAsQueryParams(queryParameters, requestData);
        queryParameters.addIfNotNull("$top", (Object)top);
        queryParameters.addIfNotNull("$skip", (Object)skip);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TfvcShelvesetRef>>(){});
    }

    public List<AssociatedWorkItem> getShelvesetWorkItems(String shelvesetId) {
        UUID locationId = UUID.fromString("a7a0c1c1-373e-425a-b031-a519474d743d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("shelvesetId", shelvesetId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<AssociatedWorkItem>>(){});
    }
}

