/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.remote.NodeJSCreateRemoteSdkForm;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateRemoteNodeJSInterpreterDialog
extends DialogWrapper
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.CreateRemoteNodeJSInterpreterDialog");
    @Nullable
    protected final Project myProject;
    private NodeJSCreateRemoteSdkForm myForm;
    private final List<String> myExistingSdkHomePaths;
    private NodeJSRemoteSdkAdditionalData myData;
    private SemVer myVersion;

    public CreateRemoteNodeJSInterpreterDialog(@Nullable Project project) {
        super(project, true);
        this.myProject = project;
        this.myExistingSdkHomePaths = new ArrayList<String>();
        this.setTitle("Configure Node.js Remote Interpreter");
        this.init();
    }

    public void setExistingSdks(@NotNull List<String> existingSdks) {
        if (existingSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingSdks", "com/jetbrains/nodejs/remote/CreateRemoteNodeJSInterpreterDialog", "setExistingSdks"));
        }
        this.myExistingSdkHomePaths.addAll(existingSdks);
    }

    public boolean reset(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/CreateRemoteNodeJSInterpreterDialog", "reset"));
        }
        NodeJSCreateRemoteSdkForm form = this.getForm();
        if (!form.supportsSdkType(data.getRemoteConnectionType())) {
            return false;
        }
        form.init((RemoteSdkAdditionalData)data);
        return true;
    }

    protected void doOKAction() {
        String validationError = this.myForm.getValidationError();
        if (!StringUtil.isEmptyOrSpaces((String)validationError)) {
            this.validationFailed(validationError);
            return;
        }
        String message = null;
        boolean useRemoteCredentials = CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)this.getForm().createSdkDataInner());
        if (useRemoteCredentials) {
            message = this.validateUsingRemoteSdkCredentials(this.myProject, this.getForm(), this.getContentPane());
        } else {
            this.getForm().updateHelpersPath(".webstorm_nodejs_helpers");
        }
        if (message != null) {
            this.validationFailed(message);
            return;
        }
        this.myData = (NodeJSRemoteSdkAdditionalData)this.getForm().createSdkData();
        if (useRemoteCredentials) {
            if (this.myVersion == null) {
                this.validationFailed("Version detection cancelled");
                return;
            }
            this.myData.setVersionString(this.myVersion.getRawVersion());
        }
        for (String existing : this.myExistingSdkHomePaths) {
            if (!StringUtil.equals((CharSequence)existing, (CharSequence)this.myData.getSdkId())) continue;
            this.validationFailed("There is already the same interpreter:\n" + existing);
            this.myData = null;
            return;
        }
        super.doOKAction();
    }

    private String validateUsingRemoteSdkCredentials(Project project, final NodeJSCreateRemoteSdkForm form, Container pane) {
        try {
            RemoteSdkCredentials data = form.computeSdkCredentials();
            final AtomicReference credentialsRef = new AtomicReference();
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteSdkCredentials)data, (String)"Connecting to remote host", (RemoteSdkUtil.RemoteSdkUpdatedCallback)new RemoteSdkUtil.RemoteSdkUpdatedCallback(){

                public void updated(RemoteSdkCredentials data) {
                    form.updateModifiedValues(data);
                    credentialsRef.set(data);
                }
            })) {
                return "Can't connect to remote host";
            }
            AtomicReference<String> error = new AtomicReference<String>();
            if (!this.detectVersionInBackground(project, (NodeJSRemoteSdkCredentials)data, error)) {
                return "Version detection cancelled";
            }
            String message = error.get();
            if (message != null) {
                return message;
            }
        }
        catch (FileSystemException e) {
            LOG.info((Throwable)e);
            return ExceptionUtil.getMessage((Throwable)e);
        }
        catch (RemoteCancelledException e) {
            return "Connection cancelled";
        }
        catch (ProcessCanceledException e) {
            return "Connection cancelled";
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return ExceptionUtil.getMessage((Throwable)e);
        }
        return null;
    }

    private boolean detectVersionInBackground(Project project, NodeJSRemoteSdkCredentials data, AtomicReference<String> error) {
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            assert (manager != null);
            try {
                this.myVersion = manager.getNodeVersion(project, data);
            }
            catch (RemoteSdkException e) {
                LOG.info((Throwable)e);
                error.set(ExceptionUtil.getMessage((Throwable)e));
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
                error.set(ExceptionUtil.getMessage((Throwable)e));
            }
        }, "Detect Interpreter Version", true, this.myProject);
    }

    public NodeJSRemoteSdkAdditionalData getData() {
        return this.myData;
    }

    private boolean validationFailed(String validation) {
        if (StringUtil.isEmpty((String)validation)) {
            validation = "Communication error";
        }
        Messages.showErrorDialog((String)validation, (String)"Can't Create Node.js Remote Interpreter");
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)((Object)this.getForm()), "Center");
        return result;
    }

    @NotNull
    private NodeJSCreateRemoteSdkForm getForm() {
        if (this.myForm == null) {
            this.myForm = new NodeJSCreateRemoteSdkForm(this.myProject, this);
        }
        NodeJSCreateRemoteSdkForm nodeJSCreateRemoteSdkForm = this.myForm;
        if (nodeJSCreateRemoteSdkForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/CreateRemoteNodeJSInterpreterDialog", "getForm"));
        }
        return nodeJSCreateRemoteSdkForm;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getForm().getPreferredFocusedComponent();
    }

    public void updateSize() {
        this.pack();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getForm().validateRemoteInterpreter();
    }
}

