/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.idea.RareLogger;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeJSRemoteSdkCredentials;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.remote.CreateRemoteNodeJSInterpreterDialog;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteTransferImpl;
import com.jetbrains.nodejs.remote.RemoteInterpreters;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SdkSessionManager;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.ui.MappingsGatherer;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsField;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRemoteInterpreterManagerImpl
extends NodeJSRemoteInterpreterManager {
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManagerImpl"), (boolean)false);
    public static final String NODE_JS = "NodeJS";
    private final RemoteInterpreters myInterpreters;

    public NodeJSRemoteInterpreterManagerImpl(RemoteInterpreters interpreters) {
        this.myInterpreters = interpreters;
    }

    public RemoteSdkCredentialsProducer<NodeJSRemoteSdkCredentials> getRemoteSdkCredentialsProducer(Function<RemoteCredentials, NodeJSRemoteSdkCredentials> credentialsTransformer, RemoteConnectionCredentialsWrapper connectionWrapper) {
        return new RemoteSdkCredentialsProducerImpl(credentialsTransformer, connectionWrapper, true);
    }

    @Nullable
    public String createRemoteInterpreter(Project project) {
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        dialog.setExistingSdks(this.getRemoteInterpreters());
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            this.myInterpreters.add(data);
            return data.getSdkId();
        }
        return null;
    }

    public List<String> getRemoteInterpreters() {
        List<NodeJSRemoteSdkAdditionalData> interpreters = this.myInterpreters.getInterpreters();
        if (interpreters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            result.add(interpreter.getSdkId());
        }
        return result;
    }

    public List<Pair<String, SemVer>> getRemoteInterpretersWithVersions() {
        List<NodeJSRemoteSdkAdditionalData> interpreters = this.myInterpreters.getInterpreters();
        if (interpreters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, SemVer>> result = new ArrayList<Pair<String, SemVer>>();
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            SemVer ver = interpreter.getVersionString() == null ? SemVer.UNKNOWN : SemVer.parseFromTextNonNullize((String)interpreter.getVersionString());
            result.add((Pair<String, SemVer>)Pair.create((Object)interpreter.getSdkId(), (Object)ver));
        }
        return result;
    }

    @NotNull
    public SemVer getNodeVersionCached(@NotNull String interpreterId) {
        SemVer semVer;
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getNodeVersionCached"));
        }
        try {
            semVer = SemVer.parseFromTextNonNullize((String)((NodeJSRemoteSdkAdditionalData)this.getRemoteSdkAdditionalData(null, interpreterId)).getVersionString());
        }
        catch (ExecutionException e) {
            SemVer semVer2 = SemVer.UNKNOWN;
            if (semVer2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getNodeVersionCached"));
            }
            return semVer2;
        }
        if (semVer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getNodeVersionCached"));
        }
        return semVer;
    }

    public SemVer getNodeVersion(@Nullable Project project, NodeJSRemoteSdkCredentials credentials) throws RemoteSdkException, InterruptedException {
        GeneralCommandLine command = new GeneralCommandLine(new String[]{credentials.getInterpreterPath(), "-v"});
        ProcessOutput output = RemoteSdkUtil.getProcessOutput((Project)project, (RemoteSdkCredentials)credentials, (GeneralCommandLine)command);
        if (output.getExitCode() != 0) {
            LOG.info("Can not get node version for path: " + credentials.getInterpreterPath() + ", process exit code = " + output.getExitCode() + "\n" + output.getStderr());
            return SemVer.UNKNOWN;
        }
        String stdout = output.getStdout().trim();
        return SemVer.parseFromText((String)(stdout.startsWith("v") ? stdout.substring(1) : stdout));
    }

    @NotNull
    public NodeJSRemoteSdkCredentials getCredentialsById(@NotNull String interpreterId) throws RemoteSdkException, InterruptedException {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getCredentialsById"));
        }
        NodeJSRemoteSdkAdditionalData data = this.getRemoteSdkAdditionalDataImpl(interpreterId);
        if (data != null) {
            NodeJSRemoteSdkCredentials nodeJSRemoteSdkCredentials;
            try {
                nodeJSRemoteSdkCredentials = data.getRemoteSdkCredentials();
            }
            catch (ExecutionException e) {
                throw new RemoteSdkException(e.getMessage(), (Throwable)e);
            }
            if (nodeJSRemoteSdkCredentials == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getCredentialsById"));
            }
            return nodeJSRemoteSdkCredentials;
        }
        throw NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreterId);
    }

    @NotNull
    public RemoteSdkAdditionalData getRemoteSdkAdditionalData(@Nullable Project project, @NotNull String interpreterId) throws ExecutionException {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getRemoteSdkAdditionalData"));
        }
        NodeJSRemoteSdkAdditionalData data = this.getRemoteSdkAdditionalDataImpl(interpreterId);
        if (data != null) {
            if (project != null && data.getRemoteConnectionType() == CredentialsType.WEB_DEPLOYMENT) {
                RemoteSdkAdditionalData remoteSdkAdditionalData = this.checkDeploymentExists(project, interpreterId, (RemoteSdkAdditionalData)data);
                if (remoteSdkAdditionalData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getRemoteSdkAdditionalData"));
                }
                return remoteSdkAdditionalData;
            }
            NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
            if (nodeJSRemoteSdkAdditionalData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getRemoteSdkAdditionalData"));
            }
            return nodeJSRemoteSdkAdditionalData;
        }
        throw NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreterId);
    }

    @NotNull
    private RemoteSdkAdditionalData checkDeploymentExists(@Nullable Project project, @NotNull String interpreterId, RemoteSdkAdditionalData data) throws ExecutionException {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "checkDeploymentExists"));
        }
        final Ref holder = Ref.create();
        data.connectionCredentials().switchType(new CredentialsCase[]{new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder credentials) {
                holder.set((Object)credentials);
            }
        }});
        if (!holder.isNull()) {
            String serverConfigId = ((WebDeploymentCredentialsHolder)holder.get()).getWebServerConfigId();
            List list = RemoteSdkUtil.getSftpServerList((Project)project);
            for (WebServerConfig config : list) {
                if (!Comparing.equal((String)config.getId(), (String)serverConfigId)) continue;
                RemoteSdkAdditionalData remoteSdkAdditionalData = data;
                if (remoteSdkAdditionalData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "checkDeploymentExists"));
                }
                return remoteSdkAdditionalData;
            }
        }
        throw new RemoteSdkException("There is no deployment configuration for remote interpreter " + interpreterId);
    }

    @Nullable
    private NodeJSRemoteSdkAdditionalData getRemoteSdkAdditionalDataImpl(@NotNull String interpreterId) {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getRemoteSdkAdditionalDataImpl"));
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)interpreterId);
        for (NodeJSRemoteSdkAdditionalData data : this.myInterpreters.getInterpreters()) {
            if (!StringUtil.equals((CharSequence)FileUtil.toSystemIndependentName((String)data.getSdkId()), (CharSequence)systemIndependentId)) continue;
            return data;
        }
        return null;
    }

    @NotNull
    public OSProcessHandler createProcessHandler(@NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull String interpreterId, int debugPort, int profilingPort) throws InterruptedException, RemoteSdkException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        SmartList ports = new SmartList();
        if (debugPort >= 0) {
            ports.add(debugPort);
        }
        if (profilingPort >= 0) {
            ports.add(profilingPort);
        }
        OSProcessHandler oSProcessHandler = this.createProcessHandler(project, commandLine, interpreterId, (List<Integer>)ports);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        return oSProcessHandler;
    }

    @NotNull
    public OSProcessHandler createProcessHandler(final @NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull String interpreterId, final @NotNull List<Integer> ports) throws InterruptedException, RemoteSdkException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        if (ports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ports", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        NodeJSRemoteSdkCredentials credentials = this.getCredentialsById(interpreterId);
        final SshRemoteSession runProcessSession = SdkSessionManager.checkConnectionAndGetSession((Project)project, (RemoteSdkCredentials)credentials);
        JschProcess process = RemoteSdkUtil.createRemoteProcess((SshRemoteSession)runProcessSession, (GeneralCommandLine)commandLine, (boolean)true, (boolean)false, (boolean)true);
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler((Process)process, commandLine.getCommandLineString());
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                try {
                    for (Integer port : ports) {
                        runProcessSession.addLocalTunnel(port.intValue(), "localhost", port.intValue());
                    }
                }
                catch (SshTransportException e) {
                    String message = "Unable to forward port: " + e.getMessage();
                    NodeUIUtil.balloonInfo((Project)project, (String)message, null, (MessageType)MessageType.WARNING);
                    LOG.info(message, (Throwable)e);
                    handler.killProcess();
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                try {
                    for (Integer port : ports) {
                        runProcessSession.removeLocalTunnel(port.intValue());
                    }
                }
                catch (SshTransportException e) {
                    String message = "Unable to remove port forwarding: " + e.getMessage();
                    NodeUIUtil.balloonInfo((Project)project, (String)message, null, (MessageType)MessageType.WARNING);
                    LOG.info(message, (Throwable)e);
                }
            }
        });
        KillableColoredProcessHandler killableColoredProcessHandler = handler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createProcessHandler"));
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static RemoteSdkException remoteInterpreterNotFound(@NotNull String interpreterId) {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "remoteInterpreterNotFound"));
        }
        RemoteSdkException remoteSdkException = new RemoteSdkException("Remote interpreter " + interpreterId + " is not found.");
        if (remoteSdkException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "remoteInterpreterNotFound"));
        }
        return remoteSdkException;
    }

    @NotNull
    public PathMappingSettings setupMappings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) throws ExecutionException {
        List list;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "setupMappings"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "setupMappings"));
        }
        try {
            list = new MappingsGatherer(project, data, NODE_JS).addDisabled(false).addUserDefined(true).assemble();
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
        PathMappingSettings pathMappingSettings = new PathMappingSettings(list);
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "setupMappings"));
        }
        return pathMappingSettings;
    }

    private static boolean notMappedInternally(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "notMappedInternally"));
        }
        return CredentialsType.SSH_HOST.equals(data.getRemoteConnectionType()) || CredentialsType.WEB_DEPLOYMENT.equals(data.getRemoteConnectionType());
    }

    @NotNull
    public NodeFileTransfer getFileTransfer(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) throws ExecutionException {
        NodeRemoteTransferImpl nodeRemoteTransferImpl;
        block4: {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getFileTransfer"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getFileTransfer"));
            }
            try {
                PathMappingSettings pathMappingSettings = this.setupMappings(project, data);
                nodeRemoteTransferImpl = new NodeRemoteTransferImpl(project, null, RemoteSdkUtil.newHelpersTransferConfigFromRemoteCredentials((RemoteSdkCredentials)data.getRemoteSdkCredentials(false)), pathMappingSettings, !NodeJSRemoteInterpreterManagerImpl.notMappedInternally(data));
                if (nodeRemoteTransferImpl != null) break block4;
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "getFileTransfer"));
        }
        return nodeRemoteTransferImpl;
    }

    @Nullable
    public String chooseRemoteFile(Project project, @NotNull String interpreterId, boolean foldersOnly) throws InterruptedException, ExecutionException {
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "chooseRemoteFile"));
        }
        return this.chooseRemoteFile(project, this.getRemoteSdkAdditionalData(project, interpreterId), foldersOnly);
    }

    @Nullable
    public String chooseRemoteFile(Project project, @NotNull RemoteSdkAdditionalData data, boolean foldersOnly) throws ExecutionException, InterruptedException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "chooseRemoteFile"));
        }
        return RemoteSdkUtil.chooseRemoteFile((Project)project, (RemoteCredentials)data.getRemoteSdkCredentials(false), (boolean)foldersOnly);
    }

    public void deleteRemoteInterpreter(String id) {
        this.myInterpreters.delete(id);
    }

    public String editRemoteInterpreter(Project project, String id) {
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        List<String> interpreters = this.getRemoteInterpreters();
        interpreters.remove(id);
        dialog.setExistingSdks(interpreters);
        NodeJSRemoteSdkAdditionalData existing = this.getRemoteSdkAdditionalDataImpl(id);
        if (existing != null) {
            if (!dialog.reset(existing)) {
                Disposer.dispose((Disposable)dialog.getDisposable());
                return null;
            }
        } else {
            Disposer.dispose((Disposable)dialog.getDisposable());
            return null;
        }
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            if (existing != null) {
                this.myInterpreters.delete(existing.getSdkId());
            }
            this.myInterpreters.add(data);
            return data.getSdkId();
        }
        return null;
    }

    public Pair<TextFieldWithBrowseButton, Consumer<NodeJsInterpreter>> createRemoteMappingsField(@NotNull Project project, @NotNull Disposable disposable, @NotNull Consumer<String> errorConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createRemoteMappingsField"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createRemoteMappingsField"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "createRemoteMappingsField"));
        }
        RemoteMappingsField field = new RemoteMappingsField(project, NODE_JS, errorConsumer, disposable){

            @NotNull
            public JComponent getDescriptionComponent(@NotNull String serverId) {
                if (serverId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl$3", "getDescriptionComponent"));
                }
                JEditorPane jEditorPane = SwingHelper.createHtmlLabel((String)("<a href=\"#\">Path mappings</a> <font style=\"color:#" + Integer.toHexString(UIUtil.getInactiveTextColor().getRGB()).substring(2) + "\">for Run/Debug Configurations on " + serverId + "</font>"), null, s -> HelpManager.getInstance().invokeHelp("remote.mappings"));
                if (jEditorPane == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl$3", "getDescriptionComponent"));
                }
                return jEditorPane;
            }
        };
        Consumer changesListener = interpreter -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "lambda$createRemoteMappingsField$0"));
            }
            if (errorConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl", "lambda$createRemoteMappingsField$0"));
            }
            NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
            if (remoteInterpreter != null) {
                try {
                    RemoteSdkAdditionalData data = this.getRemoteSdkAdditionalData(project, remoteInterpreter.getReferenceName());
                    CredentialsType type = data.getRemoteConnectionType();
                    if (type instanceof CredentialsTypeEx && !((CredentialsTypeEx)type).isBrowsingAvailable()) {
                        field.clearAndHide();
                        return;
                    }
                    if (data.connectionCredentials() != null) {
                        field.updateServerId(data.connectionCredentials().getId(), data);
                    }
                }
                catch (ExecutionException e) {
                    errorConsumer.consume((Object)e.getMessage());
                }
            } else {
                field.clearAndHide();
            }
        };
        return Pair.create((Object)field.getField(), (Object)changesListener);
    }
}

