/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRemoteTransferImpl
extends RemoteTransfer
implements NodeFileTransfer {
    private final PathMappingSettings myPathMappingSettings;
    private final boolean myHasInternalMapping;

    protected NodeRemoteTransferImpl(@Nullable Project project, @Nullable Component component, @NotNull RemoteTransfer.HelpersTransferConfig helpersTransferConfig, PathMappingSettings pathMappingSettings, boolean hasInternalMapping) {
        if (helpersTransferConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpersTransferConfig", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "<init>"));
        }
        super(project, component, helpersTransferConfig);
        this.myPathMappingSettings = pathMappingSettings;
        this.myHasInternalMapping = hasInternalMapping;
    }

    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        if (remoteWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteWorkingDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "listDirectoryContents"));
        }
        return (List)NodeRemoteTransferImpl.withHelper(this, "ListRemoteDir", "Preparing remote profiling context", helper -> {
            if (remoteWorkingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteWorkingDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$listDirectoryContents$0"));
            }
            return new Worker((Helper)helper).listDirectoryContents(remoteWorkingDir);
        });
    }

    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "copy"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "copy"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "copy"));
        }
        NodeRemoteTransferImpl.withHelper(this, "Copy Files", "Copy files", helper -> {
            if (sourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$copy$1"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$copy$1"));
            }
            if (targetDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$copy$1"));
            }
            new Worker((Helper)helper).copy(sourceDir, names, targetDir);
            return true;
        });
    }

    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "fetch"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "fetch"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "fetch"));
        }
        NodeRemoteTransferImpl.withHelper(this, "Fetch Files from Remote", "Fetching files from remote", helper -> {
            if (sourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$fetch$2"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$fetch$2"));
            }
            if (targetDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$fetch$2"));
            }
            new Worker((Helper)helper).fetch(sourceDir, names, targetDir);
            return true;
        });
    }

    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "fetch"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "fetch"));
        }
        NodeRemoteTransferImpl.withHelper(this, "Fetch Files from Remote", "Fetching files from remote", helper -> {
            if (sourcePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$fetch$3"));
            }
            if (targetPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$fetch$3"));
            }
            new Worker((Helper)helper).fetch(sourcePath, targetPath);
            return true;
        });
    }

    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "copyToRemoteTmpFile"));
        }
        return (String)NodeRemoteTransferImpl.withHelper(this, "CopyProxy", "Copying file", helper -> {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$copyToRemoteTmpFile$4"));
            }
            return new Worker((Helper)helper).copyToRemoteTmpFile(remoteDir, localFileName, content);
        });
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "getMappingFor"));
        }
        return NodeRemoteTransferImpl.getMappingsStatic(localPath, this.myPathMappingSettings);
    }

    @NotNull
    private static FileObject createRemoteTmpFile(RemoteTransfer.RemoteSdkExecutionContext context, @NotNull String remoteDir, String localFileName) throws FileSystemException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "createRemoteTmpFile"));
        }
        FileObject remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(remoteDir + "/" + localFileName), false);
        if (remoteFile.exists()) {
            for (int i = 0; i < 1000; ++i) {
                remoteFile = context.findRemoteFile(new WebServerConfig.RemotePath(remoteDir + "/" + i + localFileName), false);
                if (remoteFile.exists()) continue;
                FileObject fileObject = remoteFile;
                if (fileObject == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "createRemoteTmpFile"));
                }
                return fileObject;
            }
            throw new FileSystemException("Was not able to find path for remote temp file");
        }
        FileObject fileObject = remoteFile;
        if (fileObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "createRemoteTmpFile"));
        }
        return fileObject;
    }

    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "getPathForTempFile"));
        }
        return (String)NodeRemoteTransferImpl.withHelper(this, "FindTempPath", "Finding path for temp file", helper -> {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$getPathForTempFile$5"));
            }
            return new Worker((Helper)helper).getPathForTempFile(remoteDir, localFileName);
        });
    }

    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "grouped"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "grouped"));
        }
        NodeRemoteTransferImpl.withHelper(this, title, title, helper -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$grouped$6"));
            }
            consumer.consume((Object)new Worker((Helper)helper));
            return true;
        });
    }

    public void deleteRemote(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "deleteRemote"));
        }
        NodeRemoteTransferImpl.withHelper(this, "DeleteFile", "Delete file", helper -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$deleteRemote$7"));
            }
            new Worker((Helper)helper).deleteRemote(path);
            return true;
        });
    }

    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "delete"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "delete"));
        }
        NodeRemoteTransferImpl.withHelper(this, "DeleteFiles", "Delete files", helper -> {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$delete$8"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$delete$8"));
            }
            new Worker((Helper)helper).delete(dir, set);
            return true;
        });
    }

    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "mkDir"));
        }
        return (Boolean)NodeRemoteTransferImpl.withHelper(this, "CreateFolder", "Create folder", helper -> {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$mkDir$9"));
            }
            return new Worker((Helper)helper).mkDir(remoteDir, name);
        });
    }

    public boolean hasInternalMapping() {
        return this.myHasInternalMapping;
    }

    public boolean isLocal() {
        return false;
    }

    private static <T> T withHelper(NodeRemoteTransferImpl transfer, String name, String title, @NotNull ThrowableConvertor<Helper, T, IOException> consumer) throws IOException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "withHelper"));
        }
        Helper helper = new Helper(transfer, name, title);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return (T)consumer.convert((Object)helper);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "lambda$withHelper$10"));
            }
            return consumer.convert((Object)helper);
        }, title, true, transfer.getProject());
    }

    @NotNull
    private static String getMappingsStatic(@NotNull String localPath, PathMappingSettings mappings) throws ExecutionException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "getMappingsStatic"));
        }
        if (!mappings.canReplaceLocal(localPath)) {
            throw new ExecutionException("Can not find mapping for " + localPath);
        }
        String string = mappings.convertToRemote(localPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl", "getMappingsStatic"));
        }
        return string;
    }

    private static class Helper {
        private final RemoteConnection myConnection;
        private final CredentialsDeployable myDeployable;
        private final NodeRemoteTransferImpl myTransfer;
        private ProgressIndicator myIndicator;

        private Helper(NodeRemoteTransferImpl transfer, String name, String title) throws FileSystemException {
            this.myTransfer = transfer;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            this.myDeployable = new CredentialsDeployable();
            this.myDeployable.setId(name + this.myDeployable.toString());
            transfer.getHelpersTransferConfig().createFileTransferConfig(this.myDeployable);
            this.myConnection = transfer.openConnection(title, (Deployable)this.myDeployable, indicator);
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myIndicator = this.myIndicator == null ? new EmptyProgressIndicator() : this.myIndicator;
        }

        public RemoteConnection getConnection() {
            return this.myConnection;
        }

        public RemoteTransfer.RemoteSdkExecutionContext createContext() {
            return this.myTransfer.getRemoteSdkExecutionContext(this.myIndicator, this.myConnection, (Deployable)this.myDeployable);
        }

        public ProgressIndicator getIndicator() {
            return this.myIndicator;
        }

        public PathMappingSettings getPathMappings() {
            return this.myTransfer.myPathMappingSettings;
        }
    }

    private static class Worker
    implements NodeFileTransfer {
        private final Helper myHelper;

        private Worker(Helper helper) {
            this.myHelper = helper;
        }

        public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "grouped"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "grouped"));
            }
            consumer.consume((Object)this);
        }

        public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
            if (remoteWorkingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteWorkingDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "listDirectoryContents"));
            }
            RemoteConnection connection = this.myHelper.getConnection();
            FileObject workingDirObj = connection.getFileSystem().resolveFile(remoteWorkingDir);
            workingDirObj.refresh();
            Object[] children = workingDirObj.getChildren();
            return ContainerUtil.map((Object[])children, (Function)((NotNullFunction)object -> object.getName().getBaseName()));
        }

        public void copy(@NotNull String sourceDir, final @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
            if (sourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "copy"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "copy"));
            }
            if (targetDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "copy"));
            }
            RemoteConnection connection = this.myHelper.getConnection();
            final FileObject sourceObject = connection.getFileSystem().resolveFile(sourceDir);
            FileObject targetObject = connection.getFileSystem().resolveFile(targetDir);
            targetObject.copyFrom(sourceObject, new FileSelector(){

                public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                    return names.contains(fileInfo.getFile().getName().getBaseName());
                }

                public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                    return fileInfo.getFile().getName().getPath().equals(sourceObject.getName().getPath());
                }
            });
        }

        public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
            if (sourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "fetch"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "fetch"));
            }
            if (targetDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "fetch"));
            }
            RemoteConnection connection = this.myHelper.getConnection();
            FileObject sourceObject = connection.getFileSystem().resolveFile(sourceDir);
            sourceObject.refresh();
            String verifiedDir = targetDir.endsWith("/") || targetDir.endsWith("\\") ? targetDir.substring(0, targetDir.length() - 1) : targetDir;
            ArrayList operations = Lists.newArrayList();
            for (String name : names) {
                FileObject remote = sourceObject.resolveFile(name);
                FileObject local = DeploymentPathUtils.getLocalFile((String)(verifiedDir + File.separator + name));
                operations.add(new TransferOperation.Copy(remote, local));
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(false);
            RemoteTransfer.executeOperationsBatch((ProgressIndicator)this.myHelper.getIndicator(), (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
        }

        public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
            FileObject sourceObject;
            if (sourcePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "fetch"));
            }
            if (targetPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "fetch"));
            }
            RemoteConnection connection = this.myHelper.getConnection();
            int dirIdx = sourcePath.replace('\\', '/').lastIndexOf(47);
            if (dirIdx > 0) {
                FileObject dir = connection.getFileSystem().resolveFile(sourcePath.substring(0, dirIdx));
                dir.refresh();
            }
            if (!(sourceObject = connection.getFileSystem().resolveFile(sourcePath)).exists()) {
                sourceObject.refresh();
            }
            ArrayList operations = Lists.newArrayList();
            operations.add(new TransferOperation.Copy(sourceObject, DeploymentPathUtils.getLocalFile((String)targetPath)));
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(false);
            RemoteTransfer.executeOperationsBatch((ProgressIndicator)this.myHelper.getIndicator(), (RemoteTransfer.RemoteSdkExecutionContext)context, (List)operations);
        }

        public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "copyToRemoteTmpFile"));
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            context.setServerSideModification(true);
            FileObject remoteFile = NodeRemoteTransferImpl.createRemoteTmpFile(context, remoteDir, localFileName);
            new TransferOperation.CreateRemoteFile(content, remoteFile).execute((ExecutionContext)context);
            return remoteFile.getName().getPath();
        }

        public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "getPathForTempFile"));
            }
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            return NodeRemoteTransferImpl.createRemoteTmpFile(context, remoteDir, localFileName).getName().getPath();
        }

        public void deleteRemote(@NotNull String path) throws IOException {
            FileObject object;
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "deleteRemote"));
            }
            FileSystem fs = this.myHelper.getConnection().getFileSystem();
            try {
                object = fs.resolveFile(path);
            }
            catch (FileSystemException e) {
                return;
            }
            object.delete();
        }

        public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
            FileObject object;
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "delete"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "delete"));
            }
            FileSystem fs = this.myHelper.getConnection().getFileSystem();
            try {
                object = fs.resolveFile(dir);
            }
            catch (FileSystemException e) {
                return;
            }
            for (String name : set) {
                FileObject child;
                try {
                    child = object.resolveFile(name);
                }
                catch (FileSystemException e) {
                    continue;
                }
                child.delete();
            }
        }

        public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
            if (remoteDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "mkDir"));
            }
            WebServerConfig.RemotePath path = new WebServerConfig.RemotePath(remoteDir + "/" + name);
            RemoteTransfer.RemoteSdkExecutionContext context = this.myHelper.createContext();
            FileObject remoteFile = context.findRemoteFile(path, false);
            if (remoteFile.exists()) {
                return true;
            }
            remoteFile.createFolder();
            return true;
        }

        public boolean isLocal() {
            return false;
        }

        public String getMappingFor(@NotNull String localPath) throws ExecutionException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/remote/NodeRemoteTransferImpl$Worker", "getMappingFor"));
            }
            PathMappingSettings mappings = this.myHelper.getPathMappings();
            return NodeRemoteTransferImpl.getMappingsStatic(localPath, mappings);
        }

        public boolean hasInternalMapping() {
            return this.myHelper.myTransfer.hasInternalMapping();
        }
    }
}

