/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeJSRemoteInterpreters", storages={@Storage(value="nodeJsRemoteInterpreters.xml"), @Storage(value="other.xml", deprecated=true)})
public class RemoteInterpreters
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String INTERPRETER_PATH = "node-remote-interpreter";
    private final List<NodeJSRemoteSdkAdditionalData> myInterpreters;
    private final Object myLock = new Object();

    public RemoteInterpreters() {
        this.myInterpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        List children = state.getChildren();
        if (children != null) {
            ArrayList<NodeJSRemoteSdkAdditionalData> list = new ArrayList<NodeJSRemoteSdkAdditionalData>();
            for (Element child : children) {
                String path = child.getAttributeValue(INTERPRETER_PATH);
                if (path == null) continue;
                list.add(NodeJSRemoteSdkAdditionalData.load((Element)child, (String)path));
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myInterpreters.clear();
                this.myInterpreters.addAll(list);
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ArrayList<NodeJSRemoteSdkAdditionalData> interpreters;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInterpreters.isEmpty()) {
                return new Element("node-remote-interpreters");
            }
            interpreters = new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters);
        }
        Element rootElement = new Element("node-remote-interpreters");
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            Element element = new Element("interpreter");
            rootElement.addContent(element);
            element.setAttribute(INTERPRETER_PATH, interpreter.getSdkId());
            interpreter.save(element);
        }
        return rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myInterpreters.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeJSRemoteSdkAdditionalData> getInterpreters() {
        Object object = this.myLock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<NodeJSRemoteSdkAdditionalData>(this.myInterpreters));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/nodejs/remote/RemoteInterpreters", "add"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myInterpreters.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/nodejs/remote/RemoteInterpreters", "delete"));
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)id);
        Object object = this.myLock;
        synchronized (object) {
            Iterator<NodeJSRemoteSdkAdditionalData> iterator = this.myInterpreters.iterator();
            while (iterator.hasNext()) {
                NodeJSRemoteSdkAdditionalData data = iterator.next();
                if (!Comparing.equal((String)FileUtil.toSystemIndependentName((String)data.getSdkId()), (String)systemIndependentId)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }
}

