/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import org.jetbrains.annotations.NotNull;

public class NodeJSDockerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.remote.NodeJSDockerUtil");
    public static final Key<Boolean> GENERATE_IMAGE = Key.create((String)"Node.JS.Docker.Generate.Image");
    public static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";

    @NotNull
    public static DockerCloudConfiguration getAccount(@NotNull DockerCredentialsHolder credentials) throws RemoteSdkException {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/nodejs/remote/docker/NodeJSDockerUtil", "getAccount"));
        }
        String accountName = credentials.getAccountName();
        if (StringUtil.isEmpty((String)accountName)) {
            throw new RemoteSdkException("Docker account not specified");
        }
        RemoteServer result = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (result == null) {
            throw new RemoteSdkException("Docker account not found");
        }
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)result.getConfiguration();
        if (dockerCloudConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/remote/docker/NodeJSDockerUtil", "getAccount"));
        }
        return dockerCloudConfiguration;
    }
}

