/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoadFilesAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)LoadFilesAction.class.getName());

    public void update(AnActionEvent e) {
        boolean invokedAtRemoteBrowser = WebDeploymentDataKeys.SERVER_TREE.getData(e.getDataContext()) != null;
        Collection<Deployable> servers = LoadFilesAction.getExtraServers(e, invokedAtRemoteBrowser, this.isChooseServer(), this.isHandleVcsChanges());
        if (!this.isChooseServer()) {
            if (invokedAtRemoteBrowser) {
                e.getPresentation().setText(this.getLoadHereMessage());
            } else if (!servers.isEmpty()) {
                e.getPresentation().setText(this.getLoadToServerMessage(servers.iterator().next()));
            }
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(!servers.isEmpty());
        } else {
            e.getPresentation().setEnabled(!servers.isEmpty());
        }
    }

    @Nls
    @NotNull
    protected abstract String getLoadHereMessage();

    @Nls
    @NotNull
    protected abstract String getLoadToServerMessage(Deployable var1);

    @Nls
    @NotNull
    protected abstract String getServerChooserTitle();

    @NotNull
    static Collection<Deployable> getExtraServers(AnActionEvent e, boolean invokedAtRemoteBrowser, boolean chooseServer, boolean handleVcsChanges) {
        Collection<Object> servers;
        if (chooseServer && invokedAtRemoteBrowser) {
            servers = Collections.emptyList();
        } else {
            Project project;
            servers = LoadFilesAction.isEnabled(e, chooseServer, handleVcsChanges);
            if (chooseServer && servers.size() == 1 && ActionPlaces.isPopupPlace((String)e.getPlace()) && ((project = e.getProject()) == null || StringUtil.equals((CharSequence)((Deployable)servers.iterator().next()).getId(), (CharSequence)((CharSequence)PublishConfig.getInstance((Project)project).getDefaultServerIdAndName().first)))) {
                servers = Collections.emptyList();
            }
        }
        List<Deployable> list = servers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "getExtraServers"));
        }
        return list;
    }

    protected boolean isChooseServer() {
        return false;
    }

    protected boolean isHandleVcsChanges() {
        return true;
    }

    @NotNull
    static Collection<Deployable> isEnabled(AnActionEvent e, boolean chooseServer, boolean handleVcsChanged) {
        Change[] changes;
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            List<Deployable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
            }
            return list;
        }
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            List<Deployable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
            }
            return list;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        if (handleVcsChanged && (changes = (Change[])VcsDataKeys.CHANGES.getData(e.getDataContext())) != null) {
            Collection<Deployable> collection = LoadFilesAction.findSuitableServers(project, publishConfig, changes, chooseServer);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
            }
            return collection;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files != null) {
            VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
            Collection<Deployable> collection = LoadFilesAction.findSuitableServers(project, publishConfig, (Collection<VirtualFile>)roots, chooseServer);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
            }
            return collection;
        }
        FileObject[] nodes = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        if (nodes != null) {
            Deployable server = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(e.getDataContext());
            LOG.assertTrue(server != null);
            if (server.validateFastInternal() != null) {
                List<Deployable> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
                }
                return list;
            }
            for (FileObject node : nodes) {
                if (publishConfig.getNearestMappingDeploy2Local(node, false, (Mappable)server).getFirst() == null && ((List)publishConfig.getChildMappingsDeploy2Local(node, (Mappable)server).getFirst()).isEmpty()) continue;
                List<Deployable> list = Collections.singletonList(server);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
                }
                return list;
            }
        }
        List<Deployable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "isEnabled"));
        }
        return list;
    }

    @NotNull
    private static Collection<Deployable> findServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Condition<WebServerConfig> include, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findServers"));
        }
        if (include == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "include", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findServers"));
        }
        List<WebServerConfig> servers = chooseServer ? WebServersConfigManager.getInstance(project).getServers(true) : Collections.singletonList(publishConfig.findDefaultServer());
        ArrayList<Deployable> result = new ArrayList<Deployable>();
        for (WebServerConfig server : servers) {
            if (server == null || server.getFileTransferConfig().validateFast() != null || !include.value((Object)server)) continue;
            result.add(Deployable.create(server));
        }
        ArrayList<Deployable> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findServers"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<Deployable> findSuitableServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Collection<VirtualFile> roots, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        Collection<Deployable> collection = LoadFilesAction.findServers(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> {
            if (publishConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "lambda$findSuitableServers$0"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "lambda$findSuitableServers$0"));
            }
            return LoadFilesAction.checkServer(publishConfig, server, roots);
        }), chooseServer);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        return collection;
    }

    @NotNull
    private static Collection<Deployable> findSuitableServers(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull Change[] changes, boolean chooseServer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        Collection<Deployable> collection = LoadFilesAction.findServers(project, publishConfig, (Condition<WebServerConfig>)((Condition)server -> {
            if (publishConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "lambda$findSuitableServers$1"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "lambda$findSuitableServers$1"));
            }
            return LoadFilesAction.checkServer(publishConfig, server, changes);
        }), chooseServer);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/LoadFilesAction", "findSuitableServers"));
        }
        return collection;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, Change[] changes) {
        if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return false;
        }
        for (Change change : changes) {
            ContentRevision afterRevision;
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (!(beforeRevision != null ? publishConfig.getNearestMappingForLocal(beforeRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null : (afterRevision = change.getAfterRevision()) != null && publishConfig.getNearestMappingForLocal(afterRevision.getFile().getPath(), false, true, false, (Mappable)server).getFirst() != null)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkServer(PublishConfig publishConfig, WebServerConfig server, Collection<VirtualFile> roots) {
        for (VirtualFile root : roots) {
            if (!PublishActionUtil.checkMapping(publishConfig, server, root.getPath(), true)) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        Change[] changes = (Change[])VcsDataKeys.CHANGES.getData(e.getDataContext());
        ChangeList[] changeLists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(e.getDataContext());
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        FileObject[] remoteFiles = (FileObject[])WebDeploymentDataKeys.REMOTE_ITEMS.getData(e.getDataContext());
        VfsUtilCore.DistinctVFilesRootsCollection roots = files != null ? new VfsUtilCore.DistinctVFilesRootsCollection(files) : null;
        RemoteConnection connection = (RemoteConnection)WebDeploymentDataKeys.REMOTE_CONNECTION.getData(e.getDataContext());
        Collection<Object> servers = changes != null ? LoadFilesAction.findSuitableServers(project, publishConfig, changes, this.isChooseServer()) : (files != null ? LoadFilesAction.findSuitableServers(project, publishConfig, Arrays.asList(files), this.isChooseServer()) : Collections.singletonList(WebDeploymentDataKeys.DEPLOYABLE.getData(e.getDataContext())));
        LOG.assertTrue(!servers.isEmpty());
        if (servers.size() == 1 && !this.isChooseServer()) {
            this.execute(project, publishConfig, servers.iterator().next(), changes, changeLists, remoteFiles, connection, (Collection<VirtualFile>)roots);
        } else {
            PublishActionUtil.chooseServer(publishConfig, servers, e, this.getServerChooserTitle()).doWhenDone(arg_0 -> this.lambda$actionPerformed$2(project, publishConfig, changes, changeLists, remoteFiles, connection, (Collection)roots, arg_0));
        }
    }

    protected abstract void execute(@NotNull Project var1, PublishConfig var2, @NotNull Deployable var3, Change[] var4, ChangeList[] var5, FileObject[] var6, @Nullable RemoteConnection var7, Collection<VirtualFile> var8);

    private /* synthetic */ void lambda$actionPerformed$2(Project project, PublishConfig publishConfig, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, RemoteConnection connection, Collection roots, Deployable server) {
        this.execute(project, publishConfig, server, changes, changeLists, remoteFiles, connection, roots);
    }
}

