/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sockets;

import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;

abstract class ItemHolder<T>
implements RemoteConnectionManager.ForceDisconnectListener {
    private Collection<T> myItems = new ArrayList<T>();
    private boolean myClosed;

    ItemHolder() {
    }

    @Override
    public synchronized void forceDisconnect() {
        this.myClosed = true;
        for (T item : this.myItems) {
            this.close(item);
        }
    }

    protected abstract void close(T var1);

    public synchronized void add(T item) throws IOException {
        if (this.myClosed) {
            this.close(item);
            throw new IOException("Connection closed");
        }
        this.myItems.add(item);
    }

    static ItemHolder<Socket> createDefaultSocketHolder() {
        return new ItemHolder<Socket>(){

            @Override
            protected void close(Socket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    static ItemHolder<ServerSocket> createDefaultServerSocketHolder() {
        return new ItemHolder<ServerSocket>(){

            @Override
            protected void close(ServerSocket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

