/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jetbrains.plugins.webDeployment.connections.SftpClientFactoryCopy;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010 H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionUtil;", "", "()V", "EXEC_CHANNEL_TYPE", "", "getEXEC_CHANNEL_TYPE", "()Ljava/lang/String;", "SFTP_CHANNEL_TYPE", "getSFTP_CHANNEL_TYPE", "SHELL_CHANNEL_TYPE", "getSHELL_CHANNEL_TYPE", "calcIdentitiesHashCode", "", "password", "identities", "", "Lorg/apache/commons/vfs2/provider/sftp/IdentityInfo;", "(Ljava/lang/String;[Lorg/apache/commons/vfs2/provider/sftp/IdentityInfo;)I", "createConfig", "Ljava/util/Properties;", "createSession", "Lcom/jcraft/jsch/Session;", "sessionConfig", "Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;", "createSession$webDeployment", "toTimeoutInMillis", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "isNullOrEmpty", "", "", "webDeployment"})
public final class SshConnectionUtil {
    @NotNull
    private static final String SHELL_CHANNEL_TYPE = "shell";
    @NotNull
    private static final String EXEC_CHANNEL_TYPE = "exec";
    @NotNull
    private static final String SFTP_CHANNEL_TYPE = "sftp";
    public static final SshConnectionUtil INSTANCE;

    public final int calcIdentitiesHashCode(@Nullable String password, @Nullable IdentityInfo[] identities) {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)password);
        if (identities != null) {
            for (int i = 0; i < identities.length; ++i) {
                IdentityInfo identity = identities[i];
                byte[] passPhrase = identity.getPassPhrase();
                hashCodeBuilder.append((Object)identity.getPublicKey()).append((Object)identity.getPrivateKey()).append(this.isNullOrEmpty(passPhrase) ? null : passPhrase);
            }
        }
        return hashCodeBuilder.toHashCode();
    }

    private final boolean isNullOrEmpty(@Nullable byte[] $receiver) {
        return $receiver == null || $receiver.length == 0;
    }

    @NotNull
    public final Session createSession$webDeployment(@NotNull SessionConfig sessionConfig) {
        Integer keepAliveCountMax;
        Integer keepAliveTimeout;
        Properties config;
        Integer timeout;
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        JSch jsch = new JSch();
        SftpClientFactoryCopy.setKnownHosts(jsch, sessionConfig.getSshDir(), sessionConfig.getKnownHostsFile());
        if (sessionConfig.getIdentityRepositoryFactory() != null) {
            IdentityRepositoryFactory identityRepositoryFactory = sessionConfig.getIdentityRepositoryFactory();
            if (identityRepositoryFactory == null) {
                Intrinsics.throwNpe();
            }
            jsch.setIdentityRepository(identityRepositoryFactory.create(jsch));
        }
        SftpClientFactoryCopy.addIdentities(jsch, sessionConfig.getSshDir(), sessionConfig.getIdentities());
        Session session = jsch.getSession(sessionConfig.getUsername(), sessionConfig.getHost(), sessionConfig.getPort());
        if (sessionConfig.getPassword() != null) {
            session.setPassword(sessionConfig.getPassword());
        }
        if ((timeout = sessionConfig.getTimeout()) != null) {
            session.setTimeout(((Number)timeout).intValue());
        }
        if (sessionConfig.getUserInfo() != null) {
            session.setUserInfo(sessionConfig.getUserInfo());
        }
        if (sessionConfig.getProxy() != null) {
            session.setProxy(sessionConfig.getProxy());
        }
        if ((config = sessionConfig.getConfig()) != null && config.size() > 0) {
            session.setConfig(config);
        }
        if (sessionConfig.getSocketFactory() != null) {
            session.setSocketFactory(sessionConfig.getSocketFactory());
        }
        if ((keepAliveTimeout = sessionConfig.getServerAliveInterval()) != null) {
            session.setServerAliveInterval(((Number)keepAliveTimeout).intValue());
        }
        if ((keepAliveCountMax = sessionConfig.getServerAliveCountMax()) != null) {
            session.setServerAliveCountMax(((Number)keepAliveCountMax).intValue());
        }
        session.setDaemonThread(sessionConfig.getDaemonThread());
        session.connect();
        Session session2 = session;
        Intrinsics.checkExpressionValueIsNotNull((Object)session2, (String)"session");
        return session2;
    }

    @NotNull
    public final Properties createConfig() {
        Properties config = new Properties();
        config.setProperty("compression.s2c", "zlib,none");
        config.setProperty("compression.c2s", "zlib,none");
        return config;
    }

    public final int toTimeoutInMillis(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        long timeoutInMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (timeoutInMillis < (long)0) {
            throw (Throwable)new IllegalArgumentException("Invalid timeout value: " + timeoutInMillis);
        }
        if (timeoutInMillis > (long)Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeoutInMillis;
    }

    @NotNull
    public final String getSHELL_CHANNEL_TYPE() {
        return SHELL_CHANNEL_TYPE;
    }

    @NotNull
    public final String getEXEC_CHANNEL_TYPE() {
        return EXEC_CHANNEL_TYPE;
    }

    @NotNull
    public final String getSFTP_CHANNEL_TYPE() {
        return SFTP_CHANNEL_TYPE;
    }

    private SshConnectionUtil() {
        INSTANCE = this;
        SHELL_CHANNEL_TYPE = SHELL_CHANNEL_TYPE;
        EXEC_CHANNEL_TYPE = EXEC_CHANNEL_TYPE;
        SFTP_CHANNEL_TYPE = SFTP_CHANNEL_TYPE;
    }

    static {
        new SshConnectionUtil();
    }
}

