/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.UriUtil;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.AdvancedOptionsDialog;
import com.jetbrains.plugins.webDeployment.ui.BrowseMountedFolderActionListener;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.Util;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerConfigForm
implements UnnamedConfigurable,
Iconable {
    private static final Logger LOG = Logger.getInstance((String)WebServerConfigForm.class.getName());
    private static final long VALIDATE_TIMEOUT = 200L;
    private static final long CHECK_PASSPHRASE_TIMEOUT_MS = 100L;
    private static final String AUTH_PASSWORD = WDBundle.message("auth.password", new Object[0]);
    private static final String AUTH_KEYPAIR = WDBundle.message("auth.keypair", new Object[0]);
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myPortField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JCheckBox mySavePasswordCheckBox;
    private MultiLineLabel myMessageLabel;
    private JButton myTestConnectionButton;
    private JCheckBox myAnonymousCheckBox;
    private JTextField myUrlField;
    private JLabel myPasswordLabel;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JLabel myPrivateKeyFileLabel;
    private JPasswordField myPassphraseField;
    private JLabel myPassphraseLabel;
    private JComboBox<String> myAuthTypeCombo;
    private JLabel myAuthTypeLabel;
    private JCheckBox mySavePassphraseCheckbox;
    private JComboBox<AccessType> myAccessTypeCombo;
    private JButton myAdvancedOptionsButton;
    private JLabel myHostLabel;
    private JLabel myRootFolderLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myRootFolderField;
    private JButton myAutodetectButton;
    private JButton myOpenUrlButton;
    private TextFieldWithBrowseButton myMountedFolderField;
    private JLabel myMountedFolderLabel;
    private JLabel myPortLabel;
    private JLabel myUsernameLabel;
    private JPanel mySpacer1;
    private JPanel mySpacer2;
    private JLabel myAccessTypeLabel;
    private JPanel myUploadPanel;
    private JPanel mySpacer3;
    private HoverHyperlinkLabel myFixLink;
    private JLabel myAccessTypeDescriptionLabel;
    private JRadioButton myExplicitFTPSRadioButton;
    private JRadioButton myImplicitFTPSRadioButton;
    private JPanel mySpacer4;
    private JBCheckBox myProjectLevelCheckBox;
    private boolean mySlowValidationTimedOut;
    private SettingsDeployable myItem;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final EventDispatcher<AccessTypeChangeListener> myAccessTypeEventDispatcher;
    private AdvancedOptionsConfig myAdvancedOptions;
    private AccessType myPreviousAccessType;
    private String myForbiddenChildPath;
    private String myPreviousHostValue;
    private boolean myMuted;
    private Disposable myDisposable;

    public WebServerConfigForm(SettingsDeployable item, Project project) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myAccessTypeEventDispatcher = EventDispatcher.create(AccessTypeChangeListener.class);
        this.myAdvancedOptions = new AdvancedOptionsConfig();
        this.myDisposable = Disposer.newDisposable((String)this.getClass().getName());
        this.myItem = item;
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myProjectLevelCheckBox.setVisible(project != null && !project.isDefault());
        this.updateAccessTypes(new AccessType[0]);
        this.myAccessTypeCombo.addActionListener(e -> {
            AccessType newAccessType = (AccessType)((Object)((Object)this.myAccessTypeCombo.getSelectedItem()));
            if (newAccessType == this.myPreviousAccessType) {
                return;
            }
            this.updateOnAccessTypeChange();
            this.myPreviousAccessType = newAccessType;
            ((AccessTypeChangeListener)this.myAccessTypeEventDispatcher.getMulticaster()).changed();
        });
        this.myAccessTypeCombo.setRenderer((ListCellRenderer<AccessType>)((Object)new AccessTypeComboRenderer()));
        this.myAnonymousCheckBox.addActionListener(e -> this.updateOnAnonymousChange());
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                WebServerConfigForm.this.fireChanged();
            }
        });
        this.myTestConnectionButton.addActionListener(e -> {
            String title = WDBundle.message("test.connection", this.getCurrentState().getAccessType().getTitle());
            this.testConnection(title, false, project);
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                WebServerConfigForm.this.updateNeedsPassphrase();
            }
        });
        this.myPrivateKeyFileField.addActionListener(WebServerConfigForm.createBrowseListenerForPrivateKey(this.myPrivateKeyFileField));
        this.myAuthTypeCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(Arrays.asList(AUTH_PASSWORD, AUTH_KEYPAIR), (Object)AUTH_PASSWORD));
        this.myAuthTypeCombo.addActionListener(e -> {
            this.updateOnAuthTypeChange();
            if (!this.myAnonymousCheckBox.isSelected()) {
                JTextField focus = this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD ? this.myPasswordField : this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)focus).requestFocus((Component)focus, false);
            }
        });
        this.myAdvancedOptionsButton.addActionListener(e -> {
            AdvancedOptionsDialog d = new AdvancedOptionsDialog(this.myContentPane, this.myAdvancedOptions, (AccessType)((Object)((Object)this.myAccessTypeCombo.getSelectedItem())));
            d.show();
        });
        this.myRootFolderLabel.setLabelFor(this.myRootFolderField.getTextField());
        this.myRootFolderField.addActionListener(e -> {
            WebServerConfig.RemotePath path;
            SettingsDeployable server = this.getCurrentState();
            String title = WDBundle.message("choose.root.path", server.getName(), server.getHost());
            WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(this.myRootFolderField.getText());
            Project project1 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myRootFolderField));
            ServerBrowserDialog d = project1 != null ? new ServerBrowserDialog(project1, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)this.myRootFolderField, (Deployable)server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath);
            d.show();
            this.updatePassword(server);
            if (d.isOK() && (path = d.getPath()) != null) {
                this.myRootFolderField.setText(path.path);
            }
        });
        this.myAutodetectButton.addActionListener(e -> {
            String homePath = this.testConnection(WDBundle.message("autodetect.root.path", new Object[0]), true, project);
            if (homePath != null) {
                this.myRootFolderField.setText(homePath);
            }
        });
        this.myOpenUrlButton.addActionListener(e -> BrowserUtil.browse((String)this.myUrlField.getText()));
        this.myMountedFolderField.addBrowseFolderListener((TextBrowseFolderListener)new BrowseMountedFolderActionListener(new FileChooserDescriptor(false, true, false, true, false, false), null){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$3", "onFileChosen"));
                }
                super.onFileChosen(chosenFile);
                WebServerConfigForm.this.mySlowValidationTimedOut = false;
            }
        });
        this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String url = StringUtil.trimStart((String)StringUtil.notNullize((String)WebServerConfigForm.this.myUrlField.getText()), (String)"http://");
                String newHost = WebServerConfigForm.this.myHostField.getText();
                if (!WebServerConfigForm.this.myMuted && Comparing.equal((String)url, (String)WebServerConfigForm.this.myPreviousHostValue)) {
                    String urlFieldContent = newHost.startsWith("http://") || newHost.startsWith("https://") ? newHost : "http://" + newHost;
                    WebServerConfigForm.this.myUrlField.setText(urlFieldContent);
                }
                WebServerConfigForm.this.myPreviousHostValue = newHost;
            }
        });
        this.getFixLink().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                        WebServerConfigForm.this.updateWarning(true);
                    }, WDBundle.message("validating.server", new Object[0]), false, null, (JComponent)WebServerConfigForm.this.myContentPane);
                }
            }
        });
        ButtonGroup sftpButtonGroup = new ButtonGroup();
        sftpButtonGroup.add(this.myExplicitFTPSRadioButton);
        sftpButtonGroup.add(this.myImplicitFTPSRadioButton);
        boolean passwordSafeSaves = WebServerConfigForm.showSaveCheckboxed();
        this.mySavePasswordCheckBox.setVisible(passwordSafeSaves);
        this.mySavePassphraseCheckbox.setVisible(passwordSafeSaves);
        if (!passwordSafeSaves) {
            this.myItem.updateCredentialsFromPasswordSafe();
        }
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(PasswordSafeSettings.TOPIC, (Object)new PasswordSafeSettingsListener(){

            public void typeChanged(@NotNull ProviderType oldValue, @NotNull ProviderType newValue) {
                boolean phrase;
                boolean word;
                if (oldValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$6", "typeChanged"));
                }
                if (newValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$6", "typeChanged"));
                }
                if (oldValue == newValue) {
                    return;
                }
                if (newValue != ProviderType.KEYCHAIN) {
                    word = false;
                    phrase = false;
                } else {
                    AccessType type = (AccessType)((Object)WebServerConfigForm.this.myAccessTypeCombo.getSelectedItem());
                    if (type == AccessType.FTP || type == AccessType.FTPS) {
                        word = true;
                        phrase = false;
                    } else if (type == AccessType.SFTP) {
                        Object myAuthTypeComboSelectedItem = WebServerConfigForm.this.myAuthTypeCombo.getSelectedItem();
                        word = myAuthTypeComboSelectedItem == AUTH_PASSWORD;
                        phrase = myAuthTypeComboSelectedItem == AUTH_KEYPAIR;
                    } else {
                        word = false;
                        phrase = false;
                    }
                }
                WebServerConfigForm.this.mySavePasswordCheckBox.setVisible(word);
                if (!word) {
                    WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                }
                WebServerConfigForm.this.mySavePassphraseCheckbox.setVisible(phrase);
                if (!phrase) {
                    WebServerConfigForm.this.mySavePassphraseCheckbox.setSelected(false);
                }
            }

            public void credentialStoreCleared() {
                WebServerConfigForm.this.myUsernameField.setText(null);
                WebServerConfigForm.this.myPassphraseField.setText(null);
                WebServerConfigForm.this.mySavePassphraseCheckbox.setSelected(false);
                WebServerConfigForm.this.myPasswordField.setText(null);
                WebServerConfigForm.this.mySavePasswordCheckBox.setSelected(false);
                WebServerConfigForm.this.myItem.updateCredentialsFromPasswordSafe();
            }
        });
    }

    private static boolean showSaveCheckboxed() {
        return !PasswordSafe.getInstance().isMemoryOnly();
    }

    @NotNull
    public static ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> createBrowseListenerForPrivateKey(@NotNull TextFieldWithBrowseButton privateKeyFileField) {
        if (privateKeyFileField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKeyFileField", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "createBrowseListenerForPrivateKey"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
        descriptor.setHideIgnored(false);
        descriptor.withShowHiddenFiles(true);
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseFolderActionListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(WDBundle.message("choose.private.key", new Object[0]), "", (ComponentWithBrowseButton)privateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initial = super.getInitialFile();
                if (initial != null) {
                    return initial;
                }
                return this.getSshHome();
            }

            @Nullable
            private VirtualFile getSshHome() {
                String userHome = SystemProperties.getUserHome();
                if (userHome == null) {
                    return null;
                }
                File file = new File(userHome, ".ssh");
                if (!file.exists()) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        };
        if (browseFolderActionListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "createBrowseListenerForPrivateKey"));
        }
        return browseFolderActionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePassword(@NotNull SettingsDeployable server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "updatePassword"));
        }
        this.myMuted = true;
        try {
            String password;
            Credentials credentials = server.getCredentials();
            String string = password = credentials == null ? null : credentials.getPasswordAsString();
            if (server.getAccessType() == AccessType.SFTP && server.isUseKeyPair()) {
                this.myPassphraseField.setText(password);
            } else if (server.getAccessType().isProtocolBased()) {
                this.myPasswordField.setText(password);
            }
        }
        finally {
            this.myMuted = false;
        }
    }

    public void fireChanged() {
        if (!this.myMuted) {
            SettingsDeployable effective = this.updateUi();
            ((Listener)this.myEventDispatcher.getMulticaster()).changed(effective);
        }
    }

    public void updateAccessTypes(AccessType ... accessTypes) {
        EnumComboBoxModel comboModel;
        if (accessTypes.length == 0) {
            comboModel = new EnumComboBoxModel(AccessType.class);
        } else {
            ArrayList<AccessType> list = new ArrayList<AccessType>();
            for (AccessType accessType : AccessType.values()) {
                if (!ArrayUtil.contains((Object)((Object)accessType), (Object[])accessTypes)) continue;
                list.add(accessType);
            }
            comboModel = new CollectionComboBoxModel(list, list.get(0));
        }
        this.myAccessTypeCombo.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeLabel.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeCombo.setModel((ComboBoxModel<AccessType>)comboModel);
        this.updateOnAccessTypeChange();
        this.updateOnAuthTypeChange();
    }

    public void setItem(SettingsDeployable item) {
        this.myItem = item;
        this.reset();
    }

    @Nullable
    private String testConnection(String title, boolean detectHomePath, Project project) {
        SettingsDeployable serverConfig = this.getCurrentState();
        if (!AuthHelper.ensureAuthSpecified(project, serverConfig, false, ConnectionOwnerFactory.createConnectionOwner(this.myContentPane))) {
            return null;
        }
        try {
            String homePath = PublishUtils.testConnection(serverConfig, this.myContentPane, title, false);
            if (!detectHomePath) {
                Messages.showInfoMessage((String)WDBundle.message("connection.to.successful", serverConfig.getHost()), (String)title);
            }
            if (!serverConfig.isAnonymous()) {
                Credentials credentials = serverConfig.getCredentials();
                String password = credentials == null ? null : credentials.getPasswordAsString();
                boolean isStorePassword = !serverConfig.isPassMemoryOnly();
                this.myUsernameField.setText(credentials == null ? null : credentials.getUserName());
                if (serverConfig.getAccessType() == AccessType.SFTP && serverConfig.isUseKeyPair()) {
                    this.myPassphraseField.setText(password);
                    this.mySavePassphraseCheckbox.setSelected(isStorePassword);
                } else {
                    this.myPasswordField.setText(password);
                    this.mySavePasswordCheckBox.setSelected(isStorePassword);
                }
            }
            return homePath;
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((String)WDBundle.message("connection.to.failed", serverConfig.getHost(), StringUtil.capitalize((String)PublishUtils.getMessage(e, false))), (String)title);
            return null;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    private void updateNeedsPassphrase() {
        boolean needsPassphrase;
        String privateKeyPath = this.myPrivateKeyFileField.getText();
        if (StringUtil.isEmpty((String)privateKeyPath)) {
            boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
            this.myPasswordField.setEnabled(!isAnonymous);
            this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
            return;
        }
        try {
            needsPassphrase = (Boolean)Util.runWithTimeout(100L, () -> WebServerConfigForm.needsKeyPassphrase(privateKeyPath));
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to check key for passphrase: " + privateKeyPath);
            needsPassphrase = true;
        }
        if (needsPassphrase) {
            if (!this.myPassphraseField.isEnabled()) {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(true);
                this.mySavePassphraseCheckbox.setEnabled(true);
            }
        } else {
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setEnabled(false);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.mySavePassphraseCheckbox.setEnabled(false);
        }
    }

    private static boolean needsKeyPassphrase(@NotNull String privateKeyPath) {
        if (privateKeyPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKeyPath", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "needsKeyPassphrase"));
        }
        boolean needsPassphrase = true;
        File file = new File(privateKeyPath);
        if (file.isFile() && file.canRead()) {
            try {
                KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                needsPassphrase = keyPair == null || keyPair.isEncrypted();
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
        return needsPassphrase;
    }

    private void updateOnAuthTypeChange() {
        if (!((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).isProtocolBased()) {
            return;
        }
        if (this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(WebServerConfigForm.showSaveCheckboxed());
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText(null);
            int width = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(width, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(WebServerConfigForm.showSaveCheckboxed());
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        }
    }

    private void updateOnAnonymousChange() {
        boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
        this.myUsernameField.setEnabled(!isAnonymous);
        this.myPasswordField.setEnabled(!isAnonymous);
        this.myPassphraseField.setEnabled(!isAnonymous);
        this.myPrivateKeyFileField.setEnabled(!isAnonymous);
        this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
        this.mySavePassphraseCheckbox.setEnabled(!isAnonymous);
        this.myAuthTypeCombo.setEnabled(!isAnonymous);
        if (isAnonymous) {
            this.myUsernameField.setText("anonymous");
            this.myPasswordField.setText(null);
            this.mySavePasswordCheckBox.setSelected(false);
            this.myPrivateKeyFileField.setText(null);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
        } else {
            this.myUsernameField.setText(null);
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.myUsernameField, false);
        }
    }

    private void updateOnAccessTypeChange() {
        boolean ftpSftp;
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        if (accessType == AccessType.FTP) {
            this.myHostLabel.setText(WDBundle.message("host.ftp", new Object[0]));
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.SFTP) {
            this.myHostLabel.setText(WDBundle.message("host.sftp", new Object[0]));
            boolean isAnonymous = this.myAnonymousCheckBox.isSelected();
            if (isAnonymous) {
                this.myAnonymousCheckBox.setSelected(false);
                this.myUsernameField.setText(null);
            }
            this.myUsernameField.setEnabled(!isAnonymous);
            this.myPasswordField.setEnabled(!isAnonymous);
            this.mySavePasswordCheckBox.setEnabled(!isAnonymous);
            this.myAuthTypeLabel.setVisible(true);
            this.myAuthTypeCombo.setVisible(true);
            this.myUploadPanel.setVisible(true);
            this.mySpacer3.setVisible(true);
            ftpSftp = true;
        } else if (accessType == AccessType.FTPS) {
            this.myHostLabel.setText(WDBundle.message("host.ftps", new Object[0]));
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.MOUNT) {
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myUploadPanel.setVisible(true);
            this.mySpacer3.setVisible(true);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        } else {
            this.myUploadPanel.setVisible(false);
            this.mySpacer3.setVisible(false);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        }
        this.myTestConnectionButton.setVisible(ftpSftp);
        this.myHostLabel.setVisible(ftpSftp);
        this.myHostField.setVisible(ftpSftp);
        this.myPortLabel.setVisible(ftpSftp);
        this.myPortField.setVisible(ftpSftp);
        this.myRootFolderLabel.setVisible(ftpSftp);
        this.myRootFolderField.setVisible(ftpSftp);
        this.myAutodetectButton.setVisible(ftpSftp);
        this.myUsernameLabel.setVisible(ftpSftp);
        this.myUsernameField.setVisible(ftpSftp);
        this.myAnonymousCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myPasswordLabel.setVisible(ftpSftp);
        this.myPasswordField.setVisible(ftpSftp);
        this.myPassphraseLabel.setVisible(accessType == AccessType.SFTP);
        this.myPassphraseField.setVisible(accessType == AccessType.SFTP);
        this.mySavePasswordCheckBox.setVisible(ftpSftp && WebServerConfigForm.showSaveCheckboxed());
        this.mySavePassphraseCheckbox.setVisible(accessType == AccessType.SFTP && WebServerConfigForm.showSaveCheckboxed());
        this.myAdvancedOptionsButton.setVisible(ftpSftp);
        this.myPrivateKeyFileLabel.setVisible(ftpSftp);
        this.myPrivateKeyFileField.setVisible(ftpSftp);
        this.myExplicitFTPSRadioButton.setVisible(accessType == AccessType.FTPS);
        this.myImplicitFTPSRadioButton.setVisible(accessType == AccessType.FTPS);
        this.mySpacer4.setVisible(accessType == AccessType.FTPS);
        this.mySpacer1.setVisible(ftpSftp);
        this.mySpacer2.setVisible(ftpSftp);
        this.myMountedFolderLabel.setVisible(!ftpSftp);
        this.myMountedFolderField.setVisible(!ftpSftp);
        if (ftpSftp) {
            this.myPortField.setText(String.valueOf(accessType.getDefaultPort()));
            this.myTestConnectionButton.setText(WDBundle.message("test.connection.button.label", accessType.getTitle()));
            if (StringUtil.isEmpty((String)this.myRootFolderField.getText()) || this.myPreviousAccessType != null && this.myPreviousAccessType.getDefaultRootFolder().equals(this.myRootFolderField.getText())) {
                this.myRootFolderField.setText(accessType.getDefaultRootFolder());
            }
            this.updateOnAuthTypeChange();
        }
        this.myAccessTypeDescriptionLabel.setText(accessType.getDescription());
    }

    public JComponent createComponent() {
        return this.myContentPane;
    }

    public boolean isModified() {
        if (!Comparing.equal((String)this.myItem.getUrl(), (String)this.myUrlField.getText()) || this.myItem.isProjectLevel() != this.myProjectLevelCheckBox.isSelected()) {
            return true;
        }
        if (this.myItem.getAccessType() != this.myAccessTypeCombo.getSelectedItem() || !Comparing.strEqual((String)this.myItem.getHost(), (String)this.getHost()) || !Comparing.strEqual((String)this.myItem.getLiteralPort(), (String)this.myPortField.getText()) || this.myItem.isAnonymous() != this.myAnonymousCheckBox.isSelected()) {
            return true;
        }
        if (!this.myItem.isAnonymous()) {
            boolean isFormPassSaved;
            String password;
            String username;
            Credentials credentials = this.myItem.getCredentials();
            if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getUserName()), (String)(username = StringUtil.notNullize((String)this.myUsernameField.getText()).trim())) || this.myItem.isUseKeyPair() != (this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR) || !Comparing.strEqual((String)this.myItem.getPrivateKeyFile(), (String)this.myPrivateKeyFileField.getText())) {
                return true;
            }
            if (!Comparing.strEqual((String)(credentials == null ? null : credentials.getPasswordAsString()), (String)(password = new String(this.myItem.isUseKeyPair() ? this.myPassphraseField.getPassword() : this.myPasswordField.getPassword())))) {
                return true;
            }
            boolean bl = isFormPassSaved = this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR ? this.mySavePassphraseCheckbox.isSelected() : this.mySavePasswordCheckBox.isSelected();
            if (this.myItem.isPassMemoryOnly() == isFormPassSaved) {
                return true;
            }
        }
        if (!this.myAdvancedOptions.equals(this.myItem.getAdvancedOptions())) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getRootFolder()), (String)this.myRootFolderField.getText())) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myItem.getMountedFolder()), (String)StringUtil.notNullize((String)this.getMountedFolder()))) {
            return true;
        }
        return this.myItem.isFtpsExplicit() != this.myExplicitFTPSRadioButton.isSelected();
    }

    public void apply() {
        this.applyTo(this.myItem, true);
    }

    @Nullable
    private String getHost() {
        String host = this.myHostField.getText();
        if (host != null) {
            host = UriUtil.trimTrailingSlashes((String)host);
        }
        return host;
    }

    public void applyTo(@NotNull SettingsDeployable serverConfig, boolean isApplyCredentials) {
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "applyTo"));
        }
        serverConfig.setUrl(this.myUrlField.getText());
        serverConfig.setIsProjectLevel(this.myProjectLevelCheckBox.isSelected());
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        serverConfig.setAccessType(accessType);
        if (accessType.isProtocolBased()) {
            serverConfig.setHost(this.getHost());
            serverConfig.setLiteralPort(this.myPortField.getText());
            serverConfig.setUseKeyPair(this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR);
            serverConfig.setPrivateKeyFile(serverConfig.isUseKeyPair() ? this.myPrivateKeyFileField.getText() : null);
            if (this.myAnonymousCheckBox.isSelected()) {
                serverConfig.setAnonymous(true);
                serverConfig.setCredentials(null, false, isApplyCredentials, false);
            } else {
                boolean memoryOnly;
                char[] password;
                serverConfig.setAnonymous(false);
                char[] cArray = password = serverConfig.isUseKeyPair() ? this.myPassphraseField.getPassword() : this.myPasswordField.getPassword();
                boolean bl = serverConfig.isUseKeyPair() ? !this.mySavePassphraseCheckbox.isSelected() : (memoryOnly = !this.mySavePasswordCheckBox.isSelected());
                if (memoryOnly && password.length == 0) {
                    password = null;
                }
                String userName = StringUtil.nullize((String)this.myUsernameField.getText());
                Credentials credentials = new Credentials(userName, password);
                serverConfig.setCredentials(credentials, memoryOnly, isApplyCredentials, false);
            }
            serverConfig.setAdvancedOptions(this.myAdvancedOptions.clone());
            serverConfig.setRootFolder(this.myRootFolderField.getText());
            serverConfig.setMountedFolder(null);
            serverConfig.setFtpsExplicit(this.myExplicitFTPSRadioButton.isSelected());
        } else {
            serverConfig.eraseCredentialsFromPasswordSafe();
            serverConfig.setHost(null);
            serverConfig.setPort(0);
            serverConfig.setAnonymous(false);
            serverConfig.setRootFolder(new FileTransferConfig().getRootFolder());
            serverConfig.setUseKeyPair(false);
            serverConfig.setPrivateKeyFile(null);
            serverConfig.setAdvancedOptions(new AdvancedOptionsConfig());
            if (accessType == AccessType.MOUNT) {
                serverConfig.setMountedFolder(this.getMountedFolder());
            } else {
                serverConfig.setMountedFolder(null);
            }
        }
    }

    public String getMountedFolder() {
        String s = this.myMountedFolderField.getText();
        if (StringUtil.isEmpty((String)s)) {
            return s;
        }
        return new File(s).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.myMuted = true;
        try {
            this.myUrlField.setText(this.myItem.getUrl());
            this.myProjectLevelCheckBox.setSelected(this.myItem.isProjectLevel());
            this.myRootFolderField.setText(this.myItem.getRootFolder());
            this.myHostField.setText(this.myItem.getHost());
            this.myPreviousHostValue = this.myHostField.getText();
            this.myAccessTypeCombo.setSelectedItem((Object)this.myItem.getAccessType());
            this.updateOnAccessTypeChange();
            this.myPortField.setText(this.myItem.getLiteralPort());
            this.myAnonymousCheckBox.setSelected(this.myItem.isAnonymous());
            this.updateOnAnonymousChange();
            if (!this.myItem.isAnonymous()) {
                this.myItem.updateCredentialsFromPasswordSafe();
                Credentials credentials = this.myItem.getCredentials();
                String userName = credentials == null ? "" : credentials.getUserName();
                this.myUsernameField.setText(userName);
                String password = credentials == null ? "" : credentials.getPasswordAsString();
                this.myPasswordField.setText(password);
                this.myPassphraseField.setText(password);
                boolean isStorePassword = !this.myItem.isPassMemoryOnly();
                this.mySavePasswordCheckBox.setSelected(isStorePassword);
                this.mySavePassphraseCheckbox.setSelected(isStorePassword);
            }
            this.myPrivateKeyFileField.setText(this.myItem.getPrivateKeyFile());
            this.myAuthTypeCombo.setSelectedItem(this.myItem.isUseKeyPair() ? AUTH_KEYPAIR : AUTH_PASSWORD);
            this.myAdvancedOptions = this.myItem.getAdvancedOptions().clone();
            this.myMountedFolderField.setText(this.myItem.getMountedFolder());
            this.updateOnAuthTypeChange();
            this.updateNeedsPassphrase();
            if (this.myItem.isFtpsExplicit()) {
                this.myExplicitFTPSRadioButton.setSelected(true);
            } else {
                this.myImplicitFTPSRadioButton.setSelected(true);
            }
            this.mySlowValidationTimedOut = false;
            this.updateUi();
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.getPreferredFocusedComponent(), false);
        }
        finally {
            this.myMuted = false;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent[] fields;
        for (JComponent field : fields = new JComponent[]{this.myHostField, this.myPortField, this.myRootFolderField, this.myUsernameField, this.myPasswordField, this.myPrivateKeyFileField, this.myPassphraseField, this.myMountedFolderField, this.myUrlField}) {
            String text;
            String string = text = field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getText() : ((JTextField)field).getText();
            if (field == this.myUrlField && "http://".equals(text)) {
                text = null;
            }
            if (!field.isEnabled() || !field.isVisible() || !StringUtil.isEmpty((String)text)) continue;
            return field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getTextField() : field;
        }
        for (JComponent field : fields) {
            if (!field.isVisible()) continue;
            return field;
        }
        return fields[0];
    }

    @NotNull
    private SettingsDeployable updateUi() {
        SettingsDeployable serverConfig = this.updateWarning(false);
        if (serverConfig == null) {
            serverConfig = this.getCurrentState();
        }
        boolean canConnect = serverConfig.validateFastInternal(false) == null;
        this.myTestConnectionButton.setEnabled(canConnect);
        this.myAutodetectButton.setEnabled(canConnect);
        this.myRootFolderField.getButton().setEnabled(canConnect);
        this.myOpenUrlButton.setEnabled(serverConfig.validateUrl() == null);
        SettingsDeployable settingsDeployable = serverConfig;
        if (settingsDeployable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "updateUi"));
        }
        return settingsDeployable;
    }

    public void setForbiddenChildPath(String forbiddenChildPath) {
        this.myForbiddenChildPath = forbiddenChildPath;
    }

    @Nullable
    private SettingsDeployable updateWarning(boolean forceSlow) {
        if (!forceSlow && this.mySlowValidationTimedOut) {
            return null;
        }
        String errorMessage = null;
        if (!this.myAnonymousCheckBox.isSelected() && StringUtil.isEmpty((String)this.myUsernameField.getText()) && ((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).isProtocolBased()) {
            errorMessage = WDBundle.message("username.is.empty", new Object[0]);
        }
        SettingsDeployable currentState = this.getCurrentState();
        if (StringUtil.isEmpty(errorMessage)) {
            File path;
            File mountedFolder;
            try {
                errorMessage = currentState.validateSlow(forceSlow ? -1L : 200L);
                this.mySlowValidationTimedOut = false;
            }
            catch (TimeoutException e) {
                errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                boolean bl = this.mySlowValidationTimedOut = !forceSlow;
            }
            if (StringUtil.isEmpty((String)errorMessage) && !StringUtil.isEmpty((String)this.myForbiddenChildPath) && VfsUtilCore.isAncestor((File)(mountedFolder = new File(this.getMountedFolder())), (File)(path = new File(this.myForbiddenChildPath)), (boolean)false)) {
                errorMessage = WDBundle.message("path.is.under.mounted.folder", mountedFolder);
            }
        }
        if (StringUtil.isEmpty(errorMessage)) {
            try {
                errorMessage = WebServerConfigForm.getNonBlockingWarnings(currentState, forceSlow ? -1L : 200L);
            }
            catch (TimeoutException e) {
                errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                this.mySlowValidationTimedOut = !forceSlow;
            }
        }
        String finalErrorMessage = errorMessage;
        Runnable updateRunnable = () -> {
            if (finalErrorMessage != null) {
                this.getMessageLabel().setText("<html>" + finalErrorMessage + "</html>");
                this.getMessageLabel().setVisible(true);
                this.getFixLink().setVisible(this.mySlowValidationTimedOut);
            } else {
                this.getMessageLabel().setText(null);
                this.getMessageLabel().setVisible(false);
                this.getFixLink().setVisible(false);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            updateRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.stateForComponent((Component)this.myContentPane));
        }
        return currentState;
    }

    private static String getNonBlockingWarnings(@NotNull SettingsDeployable currentState, long msTimeout) throws TimeoutException {
        if (currentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentState", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "getNonBlockingWarnings"));
        }
        String warning = currentState.getNonBlockingWarnings();
        if (warning != null) {
            return warning;
        }
        if (currentState.getAccessType() == AccessType.SFTP && !StringUtil.isEmpty((String)currentState.getPrivateKeyFile())) {
            boolean needsKeyPassphrase;
            OneTimeString password;
            Credentials credentials = currentState.getCredentials();
            OneTimeString oneTimeString = password = credentials == null ? null : credentials.getPassword();
            if (StringUtil.isEmpty((CharSequence)password) && (needsKeyPassphrase = ((Boolean)Util.runWithTimeout(msTimeout, () -> {
                if (currentState == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentState", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "lambda$getNonBlockingWarnings$10"));
                }
                return WebServerConfigForm.needsKeyPassphrase(currentState.getPrivateKeyFile());
            })).booleanValue())) {
                return "Provided private key requires a passphrase";
            }
        }
        return null;
    }

    @Nullable
    public String getCurrentWarning() {
        return this.getMessageLabel().getText();
    }

    public Icon getIcon(int flags) {
        Icon icon = ((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).getIcon();
        if (this.getCurrentWarning() != null) {
            icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
        }
        return icon;
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public SettingsDeployable getCurrentState() {
        SettingsDeployable currentState = this.myItem.clone();
        currentState.setAccessType(this.myItem.getAccessType());
        this.applyTo(currentState, false);
        SettingsDeployable settingsDeployable = currentState;
        if (settingsDeployable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "getCurrentState"));
        }
        return settingsDeployable;
    }

    private void createUIComponents() {
        this.myFixLink = new HoverHyperlinkLabel(WDBundle.message("revalidate", new Object[0]));
    }

    protected JLabel getMessageLabel() {
        return this.myMessageLabel;
    }

    protected HoverHyperlinkLabel getFixLink() {
        return this.myFixLink;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        MultiLineLabel multiLineLabel;
        JPanel jPanel;
        JLabel jLabel2;
        JButton jButton;
        JTextField jTextField;
        JButton jButton2;
        JTextField jTextField2;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JButton jButton3;
        JLabel jLabel4;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JButton jButton4;
        JPasswordField jPasswordField;
        JLabel jLabel5;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel6;
        JPasswordField jPasswordField2;
        JLabel jLabel7;
        JLabel jLabel8;
        JCheckBox jCheckBox3;
        JTextField jTextField3;
        JLabel jLabel9;
        JTextField jTextField4;
        JLabel jLabel10;
        JLabel jLabel11;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.myContentPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUploadPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(16, 4, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(3, 0, 1, 3, 0, 3, 2, 2, new Dimension(-1, 40), null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Upload/download project files", (int)0, (int)0, null, null));
        this.myHostLabel = jLabel11 = new JLabel();
        jLabel11.setText("Host:");
        jLabel11.setDisplayedMnemonic('O');
        jLabel11.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortLabel = jLabel10 = new JLabel();
        jLabel10.setText("Port:");
        jLabel10.setDisplayedMnemonic('P');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField4 = new JTextField();
        jTextField4.setText("");
        jPanel5.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(70, 22), null));
        this.myUsernameLabel = jLabel9 = new JLabel();
        jLabel9.setText("User name:");
        jLabel9.setDisplayedMnemonic('U');
        jLabel9.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel9, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(6, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.myAnonymousCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Login as anonymous");
        jCheckBox3.setMnemonic('N');
        jCheckBox3.setDisplayedMnemonicIndex(10);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(6, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myAuthTypeLabel = jLabel8 = new JLabel();
        jLabel8.setText("Auth type:");
        jLabel8.setDisplayedMnemonic('Y');
        jLabel8.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jLabel8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel7 = new JLabel();
        jLabel7.setText("Password:");
        jLabel7.setDisplayedMnemonic('S');
        jLabel7.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jLabel7, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel5.add((Component)jPasswordField2, new GridConstraints(8, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myPrivateKeyFileLabel = jLabel6 = new JLabel();
        jLabel6.setText("Private key file:");
        jLabel6.setDisplayedMnemonic('K');
        jLabel6.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jLabel6, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(9, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel5 = new JLabel();
        jLabel5.setText("Key passphrase:");
        jLabel5.setDisplayedMnemonic('S');
        jLabel5.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jLabel5, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel5.add((Component)jPasswordField, new GridConstraints(10, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myAdvancedOptionsButton = jButton4 = new JButton();
        jButton4.setText("Advanced options...");
        jButton4.setMnemonic('D');
        jButton4.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jButton4, new GridConstraints(15, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAuthTypeCombo = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel5.add(jComboBox, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Save passphrase");
        jCheckBox2.setMnemonic('V');
        jCheckBox2.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(10, 2, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySavePasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save password");
        jCheckBox.setMnemonic('V');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jCheckBox, new GridConstraints(8, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myRootFolderField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel5.add((Component)noPathCompletion, new GridConstraints(4, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myRootFolderLabel = jLabel4 = new JLabel();
        jLabel4.setText("Root path:");
        jLabel4.setDisplayedMnemonic('R');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutodetectButton = jButton3 = new JButton();
        jButton3.setText("Autodetect");
        jButton3.setToolTipText("Configure root folder according to the user home folder on the server.");
        jPanel5.add((Component)jButton3, new GridConstraints(4, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myMountedFolderLabel = jLabel3 = new JLabel();
        jLabel3.setText("Folder:");
        jLabel3.setDisplayedMnemonic('F');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.mySpacer2 = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(11, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        this.mySpacer1 = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myExplicitFTPSRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        ((Component)jRadioButton2).setVisible(true);
        jRadioButton2.setText("explicit");
        jRadioButton2.setMnemonic('X');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImplicitFTPSRadioButton = jRadioButton = new JRadioButton();
        ((Component)jRadioButton).setVisible(true);
        jRadioButton.setText("implicit");
        jRadioButton.setMnemonic('I');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacer4 = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel5.add((Component)jPanel2, new GridConstraints(14, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myHostField = jTextField2 = new JTextField();
        jPanel7.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, new Dimension(100, -1), null, null));
        this.myTestConnectionButton = jButton2 = new JButton();
        jButton2.setText("Test connection...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(5);
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 2, 4, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel8, new GridConstraints(5, 0, 1, 3, 0, 3, 2, 2, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Browse files on server", (int)0, (int)0, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Web server root URL:");
        jLabel12.setDisplayedMnemonic('W');
        jLabel12.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel8.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myOpenUrlButton = jButton = new JButton();
        jButton.setText("Open");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(2);
        jPanel8.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAccessTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myAccessTypeCombo = jComboBox2;
        jPanel6.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, new Dimension(200, -1), null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySpacer3 = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 5), null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        hoverHyperlinkLabel.setText("Refresh");
        hoverHyperlinkLabel.setToolTipText("Force server revalidation");
        jPanel9.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        this.myMessageLabel = multiLineLabel = new MultiLineLabel();
        multiLineLabel.setText("Label");
        jPanel9.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAccessTypeDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Description");
        ((Component)jLabel).setForeground(SystemColor.textInactiveText);
        jPanel6.add((Component)jLabel, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myProjectLevelCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Visible only for this project");
        jPanel6.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        jLabel11.setLabelFor(jTextField2);
        jLabel10.setLabelFor(jTextField4);
        jLabel9.setLabelFor(jTextField3);
        jLabel8.setLabelFor(jComboBox);
        jLabel7.setLabelFor(jPasswordField2);
        jLabel5.setLabelFor(jPasswordField);
        jLabel12.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static class AccessTypeComboRenderer
    extends ListCellRendererWrapper<AccessType> {
        public void customize(JList list, AccessType accessType, int index, boolean selected, boolean hasFocus) {
            if (accessType != null) {
                this.setText(accessType.getTitle());
                this.setIcon(accessType.getIcon());
            }
        }
    }

    public static interface AccessTypeChangeListener
    extends EventListener {
        public void changed();
    }

    public static interface Listener
    extends EventListener {
        public void changed(SettingsDeployable var1);
    }
}

