/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SyncDateFormat;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttributes {
    private static final Logger LOG = Logger.getInstance((String)FileAttributes.class.getName());
    private static final SyncDateFormat DATE_FORMAT;
    final long mySize;
    final long myLastModified;
    @Nullable
    final String myErrorMessage;
    final int myPermissons;

    static FileAttributes createFor(@NotNull FileObject file, boolean accurateTimestamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/FileAttributes", "createFor"));
        }
        try {
            return new FileAttributes(file, accurateTimestamp);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            return new FileAttributes(PublishUtils.getMessage(e, false));
        }
    }

    private FileAttributes(FileObject file, boolean accurateTimestamp) throws FileSystemException {
        FileContent content = file.getContent();
        if (file.getType() == FileType.FILE && content != null) {
            this.mySize = content.getSize();
            this.myLastModified = content.getLastModifiedTime(accurateTimestamp);
        } else {
            this.mySize = 0L;
            this.myLastModified = 0L;
        }
        this.myErrorMessage = null;
        this.myPermissons = file.getPermissions();
    }

    public FileAttributes(@Nullable String errorMessage) {
        this.mySize = 0L;
        this.myLastModified = 0L;
        this.myPermissons = -1;
        this.myErrorMessage = errorMessage;
    }

    public String getPermissionsString(boolean asNumber) {
        if (this.myPermissons == -1) {
            return "";
        }
        if (asNumber) {
            return String.valueOf(this.myPermissons);
        }
        return Util.getPermissionsAsString(this.myPermissons);
    }

    public String getFormattedLastModified() {
        return DATE_FORMAT.format(this.myLastModified);
    }

    public String getFormattedSize() {
        return PublishUtils.formatSize(this.mySize, "size.bit", "size.kilobit", "size.megabit");
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    static {
        String customPattern = System.getProperty("com.jetbrains.plugins.webDeployment.timestamp_pattern");
        DateFormat format = null;
        if (customPattern != null) {
            try {
                format = new SimpleDateFormat(customPattern);
            }
            catch (Throwable t) {
                LOG.warn("Invalid timestamp pattern: '" + customPattern + "'", t);
            }
        }
        if (format == null) {
            format = DateFormatUtil.getDateTimeFormat().getDelegate();
        }
        DATE_FORMAT = new SyncDateFormat(format);
    }
}

