/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.alloy;

import com.incors.plaf.alloy.AlloyFontTheme;
import com.incors.plaf.alloy.AlloyTheme;
import com.incors.plaf.alloy.IdeaAlloyLAF;
import com.incors.plaf.alloy.themes.custom.CustomThemeFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class AlloyIdea
extends IdeaAlloyLAF {
    public static final String NAME = "Alloy. IDEA Theme";

    public AlloyIdea() {
        super(AlloyIdea.createNativeTheme(AlloyIdea.createNativeFontTheme(true)));
        if (SystemInfo.isWindows) {
            UIDefaults defaults = UIManager.getDefaults();
            defaults.put("Tree.collapsedIcon", WindowsTreeUI.CollapsedIcon.createCollapsedIcon());
            defaults.put("Tree.expandedIcon", WindowsTreeUI.ExpandedIcon.createExpandedIcon());
        } else if (SystemInfo.isXWindow) {
            UIDefaults defaults = UIManager.getDefaults();
            defaults.put("Tree.collapsedIcon", AllIcons.Nodes.TreeExpandNode);
            defaults.put("Tree.expandedIcon", AllIcons.Nodes.TreeCollapseNode);
            defaults.put("Tree.paintLines", Boolean.FALSE);
        }
    }

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/incors/plaf/alloy/AlloyIdea", "getName"));
        }
        return NAME;
    }

    private static AlloyTheme createNativeTheme(AlloyFontTheme theme) {
        SystemColor contrast = SystemColor.scrollbar;
        SystemColor standard = SystemColor.control;
        SystemColor desktop = SystemColor.desktop;
        Color selection = SystemColor.control.darker().darker();
        Color rollover = Color.yellow.darker();
        SystemColor highlight = SystemColor.textHighlight;
        return CustomThemeFactory.createTheme((Color)contrast, (Color)standard, (Color)desktop, (Color)selection, (Color)rollover, (Color)highlight, (AlloyFontTheme)theme);
    }
}

