/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.alloy;

import com.incors.plaf.alloy.AlloyFontTheme;
import com.incors.plaf.alloy.AlloyIdea;
import com.incors.plaf.alloy.AlloyIdeaButtonUI;
import com.incors.plaf.alloy.AlloyIdeaCheckBoxUI;
import com.incors.plaf.alloy.AlloyIdeaComboBoxUI;
import com.incors.plaf.alloy.AlloyIdeaEditorPaneUI;
import com.incors.plaf.alloy.AlloyIdeaLabelUI;
import com.incors.plaf.alloy.AlloyIdeaPanelUI;
import com.incors.plaf.alloy.AlloyIdeaRadioButtonUI;
import com.incors.plaf.alloy.AlloyIdeaTabbedPaneUI;
import com.incors.plaf.alloy.AlloyIdeaTableHeaderUI;
import com.incors.plaf.alloy.AlloyIdeaTextAreaUI;
import com.incors.plaf.alloy.AlloyIdeaTextFieldUI;
import com.incors.plaf.alloy.AlloyIdeaTextPaneUI;
import com.incors.plaf.alloy.AlloyIdeaToggleButtonUI;
import com.incors.plaf.alloy.AlloyIdeaToolTipUI;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import com.incors.plaf.alloy.AlloyTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaAlloyLAF
extends AlloyLookAndFeel {
    public IdeaAlloyLAF(AlloyTheme theme) {
        super(theme);
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public String getID() {
        String string2 = this.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/incors/plaf/alloy/IdeaAlloyLAF", "getID"));
        }
        return string2;
    }

    @Nullable
    protected static AlloyFontTheme createNativeFontTheme() {
        return IdeaAlloyLAF.createNativeFontTheme(SystemInfo.isWindows);
    }

    @Nullable
    protected static AlloyFontTheme createNativeFontTheme(boolean useSystem) {
        Font subFont;
        Font windowFont;
        Font menuFont;
        Font userFont;
        Font systemFont;
        Font controlFont;
        if (!useSystem) {
            return null;
        }
        if (SystemInfo.isWindows) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            controlFont = (Font)tk.getDesktopProperty("win.defaultGUI.font");
            systemFont = (Font)tk.getDesktopProperty("win.tooltip.font");
            userFont = (Font)tk.getDesktopProperty("win.messagebox.font");
            menuFont = (Font)tk.getDesktopProperty("win.menu.font");
            windowFont = (Font)tk.getDesktopProperty("win.defaultGUI.font");
            subFont = (Font)tk.getDesktopProperty("win.status.font");
        } else if (!SystemInfo.isMac) {
            FontUIResource baseFont;
            Pair fontData = UIUtil.getSystemFontData();
            if (fontData == null) {
                return null;
            }
            windowFont = subFont = (baseFont = new FontUIResource((String)fontData.first, 0, (Integer)fontData.second));
            menuFont = subFont;
            userFont = subFont;
            systemFont = subFont;
            controlFont = subFont;
        } else {
            return null;
        }
        return new AlloyFontTheme(){

            public FontUIResource getControlTextFont() {
                return new FontUIResource(controlFont);
            }

            public FontUIResource getSystemTextFont() {
                return new FontUIResource(systemFont);
            }

            public FontUIResource getUserTextFont() {
                return new FontUIResource(userFont);
            }

            public FontUIResource getMenuTextFont() {
                return new FontUIResource(menuFont);
            }

            public FontUIResource getWindowTitleFont() {
                return new FontUIResource(windowFont);
            }

            public FontUIResource getSubTextFont() {
                return new FontUIResource(subFont);
            }
        };
    }

    protected void initClassDefaults(UIDefaults defaults) {
        super.initClassDefaults(defaults);
        defaults.put("TabbedPaneUI", AlloyIdeaTabbedPaneUI.class.getName());
        defaults.put("ComboBoxUI", AlloyIdeaComboBoxUI.class.getName());
    }

    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        defaults.put("ToolTip.foreground", SystemColor.infoText);
        defaults.put("ToolTip.background", IdeaLaf.TOOLTIP_BACKGROUND_COLOR);
        defaults.put("menu", SystemColor.control);
        defaults.put("TabbedPaneUI", AlloyIdeaTabbedPaneUI.class.getName());
        if (SystemInfo.isWindows) {
            defaults.put("TableHeaderUI", AlloyIdeaTableHeaderUI.class.getName());
        }
        defaults.put("ComboBoxUI", AlloyIdeaComboBoxUI.class.getName());
        defaults.put("LabelUI", AlloyIdeaLabelUI.class.getName());
        defaults.put("ButtonUI", AlloyIdeaButtonUI.class.getName());
        defaults.put("ToggleButtonUI", AlloyIdeaToggleButtonUI.class.getName());
        defaults.put("TextFieldUI", AlloyIdeaTextFieldUI.class.getName());
        defaults.put("RadioButtonUI", AlloyIdeaRadioButtonUI.class.getName());
        defaults.put("CheckBoxUI", AlloyIdeaCheckBoxUI.class.getName());
        defaults.put("ToolTipUI", AlloyIdeaToolTipUI.class.getName());
        defaults.put("PanelUI", AlloyIdeaPanelUI.class.getName());
        defaults.put("EditorPaneUI", AlloyIdeaEditorPaneUI.class.getName());
        defaults.put("TextAreaUI", AlloyIdeaTextAreaUI.class.getName());
        defaults.put("TextPaneUI", AlloyIdeaTextPaneUI.class.getName());
        defaults.put("ComboBox.background", SystemColor.control);
        defaults.put("ComboBox.foreground", SystemColor.controlText);
        if (!SystemInfo.isUnix && this instanceof AlloyIdea) {
            Color selection = SystemColor.control.brighter().brighter();
            defaults.put("Table.selectedForeground", selection);
            defaults.put("Tree.selectedForeground", selection);
            defaults.put("List.selectionForeground", selection);
            defaults.put("Tree.selectionForeground", selection);
            defaults.put("Table.selectionForeground", selection);
            defaults.put("MenuItem.selectionForeground", selection);
            defaults.put("Menu.selectionForeground", selection);
            defaults.put("MenuItem.acceleratorSelectionForeground", selection);
        }
        return defaults;
    }
}

